CREATE TABLE dx_sandbox.dsds_409_concurrent_logs AS


WITH
the_constants AS (
  SELECT '2018-04-01'::DATE AS start_time, '2019-04-01'::DATE AS end_time
  , 67955580::BIGINT AS channel_id --chewiemelodies
)

, concurrent_logs AS (
  SELECT DATE_TRUNC('minute',"time") AS the_minute, channel_id, AVG(total) AS concurrent_viewer
  FROM tahoe.channel_concurrents
  WHERE "date" >= (SELECT start_time FROM the_constants)
  AND   "date" < (SELECT end_time FROM the_constants)
  --AND channel_id IN (SELECT channel_id FROM the_constants)
  GROUP BY 1,2
)


SELECT * FROM concurrent_logs;
