CREATE TABLE dx_sandbox.dsds_409_game_rank AS


WITH
mw_per_game AS (
  SELECT game, SUM(mw_live_total) AS mw_live_total
  FROM cubes.daily_minutes_watched_by_game
  WHERE day>='2018-04-01' AND day<'2019-04-01'
    AND game IS NOT NULL
    AND game NOT IN
      ('Just Chatting', 'Art', 'Retro', 'VRChat', 'Music & Performing Arts', 'Travel & Outdoors', 'Programming'
      , 'testinggame', 'E3 2018', 'Food & Drink', 'Casino', 'Games + Demos', 'Talk Shows & Podcasts', 'Chess'
      , 'Crypto', 'Makers & Crafting', 'Slots', 'Desktop', 'ASMR', 'IRL', 'Talk Shows', 'Creative', 'Music'
      , 'Always On', '', 'irl', 'fortnite', 'league of legends', 'overwatch'
      , 'just chatting', 'Game Development', 'Science & Technology', 'Special Events', 'Poker', 'Auto Chess', 'Doctor Who', 'Twitch Plays')
  GROUP BY 1
)

, final_data AS (
  SELECT *
    , ROW_NUMBER () OVER(ORDER BY mw_live_total DESC) AS the_rank
  FROM mw_per_game
)


SELECT *
  , CASE
      WHEN the_rank>=1 AND the_rank<=5 THEN 'A. Rank 1-5 Game'
      WHEN the_rank>=6 AND the_rank<=10 THEN 'B. Rank 6-10 Game'
      WHEN the_rank>=11 AND the_rank<=25 THEN 'C. Rank 11-25 Game'
      WHEN the_rank>=26 AND the_rank<=50 THEN 'D. Rank 26-50 Game'
      WHEN the_rank>=51 AND the_rank<=100 THEN 'E. Rank 51-100 Game'
      WHEN the_rank>=101 THEN 'F. Rank 101+ Game'
      ELSE 'Z. ERROR'
    END AS the_rank_group
FROM final_data
;
