WITH
logs1 AS (
  SELECT extension_id, user_id
  FROM tahoe.extension_create
  WHERE state IN ('Testing') and extension_id not in (select extension_id from rollups.extension_creator_lookup)
  GROUP BY 1,2
)
, logs2 AS (
  SELECT extension_id, user_id
  FROM tahoe.extension_lifecycle
  WHERE state IN ('Testing') and extension_id not in (select extension_id from rollups.extension_creator_lookup)
  GROUP BY 1,2
)
, logs_final AS (
  SELECT extension_id, user_id
  FROM (
    SELECT * FROM logs1
    UNION ALL SELECT * FROM logs2
  ) as logs_all
  GROUP BY 1,2
)
, final AS (
  SELECT base.*, rel.extension_name, rel.extension_anchor, rel.extension_url, rel.extension_author_name, rel.extension_author_email
  FROM logs_final AS base
  JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
)
SELECT final.extension_id,final.user_id, su.login, final.extension_name, final.extension_anchor, final.extension_url, final.extension_author_name, final.extension_author_email
FROM final
LEFT JOIN analysis.sitedb_users AS su ON final.user_id = su.user_id
ORDER BY final.extension_name
