-- What % of users with an active extension have 1) Only panel(s) extensions 2) Only overlay extension or 3) both? point in time is fine

--  user_type | rows  | users 
-- -----------+-------+-------
--  0_error   |   301 |   301
--  1_panel   | 42416 | 42416
--  2_overlay | 58608 | 58608
--  3_both    | 39307 | 39307

WITH
the_timeframe AS (
SELECT '2017-05-24 13:00:00'::timestamp AS start_time
, '2017-10-24 23:59:59'::timestamp AS end_time
)

, activate_logs AS (
SELECT extension_id, user_id, MAX(time) as last_time_activate
FROM logs.extension_activate
WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
GROUP BY 1,2
)
, deactivate_logs AS (
SELECT extension_id, user_id, MAX(time) as last_time_deactivate
FROM logs.extension_deactivate
WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
GROUP BY 1,2
)
--uninstall is an implicit deactivate
, uninstall_logs AS (
SELECT extension_id, user_id, MAX(time) as last_time_uninstall
FROM logs.extension_uninstall
WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
GROUP BY 1,2
)
, extension_logs_step1 AS (
SELECT allm.*, dllm.last_time_deactivate
, CASE WHEN allm.last_time_activate > dllm.last_time_deactivate THEN 1
WHEN allm.last_time_activate IS NOT NULL AND dllm.last_time_deactivate IS NULL THEN 1
ELSE 0 END AS flag_is_activated_step1
FROM activate_logs AS allm
LEFT JOIN deactivate_logs AS dllm ON allm.extension_id = dllm.extension_id AND allm.user_id = dllm.user_id
)

, extension_logs_final AS (
SELECT els.*, ullm.last_time_uninstall
, CASE WHEN els.last_time_activate > ullm.last_time_uninstall THEN 1
WHEN els.last_time_activate IS NOT NULL AND ullm.last_time_uninstall IS NULL THEN 1
ELSE 0 END AS flag_is_activated
FROM extension_logs_step1 AS els
LEFT JOIN uninstall_logs AS ullm ON els.extension_id = ullm.extension_id AND els.user_id = ullm.user_id
WHERE els.flag_is_activated_step1=1
)


, final_table AS (
SELECT *
, CASE WHEN flag_has_panel=1 AND flag_has_overlay=1 THEN '3_both'
WHEN flag_has_panel=0 AND flag_has_overlay=1 THEN '2_overlay'
WHEN flag_has_panel=1 AND flag_has_overlay=0 THEN '1_panel'
ELSE '0_error' END AS user_type
FROM
(
SELECT user_id, MAX(CASE WHEN extension_anchor='panel' THEN 1 ELSE 0 END) AS flag_has_panel, MAX(CASE WHEN extension_anchor='video_overlay' THEN 1 ELSE 0 END) AS flag_has_overlay
FROM
(
SELECT elf.*, rel.extension_name, rel.extension_anchor
FROM extension_logs_final AS elf
LEFT JOIN analysis.released_extensions_latest AS rel ON elf.extension_id = rel.extension_id
WHERE flag_is_activated=1
)
GROUP BY 1
)
)


SELECT user_type, COUNT(1) AS rows, COUNT(DISTINCT user_id) AS users
FROM final_table
GROUP BY 1
ORDER BY 1
