-- DROP TABLE dx_sandbox.extension_content_matched_metric;
-- CREATE TABLE dx_sandbox.extension_content_matched_metric (LIKE dx_sandbox.extension_content_matched_metric_partial_ugc);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_extension_content_matched_metric_final (VARCHAR) AS
DELETE FROM dx_sandbox.extension_content_matched_metric
WHERE the_day = $1::DATE
;





--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.extension_content_matched_metric);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_extension_content_matched_metric_final (VARCHAR) AS
INSERT INTO the_temp_table (



  WITH

  the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT $1::DATE AS start_date)
  )
  , final_data AS (
    SELECT * FROM dx_sandbox.extension_content_matched_metric_partial_ugc WHERE (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
    UNION
    SELECT * FROM dx_sandbox.extension_content_matched_metric_partial_premium WHERE (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)

  )


  SELECT * FROM final_data

);



--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-01');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-01');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-02');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-02');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-03');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-03');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-04');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-04');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;




-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-05');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-05');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-06');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-06');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-07');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-07');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-08');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-08');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-09');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-09');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-10');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-10');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-11');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-11');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-12');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-12');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-13');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-13');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-14');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-14');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-15');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-15');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-16');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-16');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-17');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-17');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-18');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-18');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-19');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-19');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-20');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-20');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-21');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-21');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-22');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-22');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-23');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-23');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-24');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-24');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-25');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-25');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-26');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-26');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-27');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-27');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-28');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-28');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-29');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-29');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-30');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-30');
-- INSERT INTO dx_sandbox.extension_content_matched_metric
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;

EXECUTE the_insert_function_extension_content_matched_metric_final ('2019-07-31');		EXECUTE the_delete_function_extension_content_matched_metric_final ('2019-07-31');
INSERT INTO dx_sandbox.extension_content_matched_metric
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;







DROP TABLE the_temp_table;
DEALLOCATE the_insert_function_extension_content_matched_metric_final;
DEALLOCATE the_delete_function_extension_content_matched_metric_final;


-- --
-- --
-- -- -- QA
-- --
--
WITH the_data AS (
  SELECT the_day::DATE, COUNT(1) AS rows, COUNT(DISTINCT channel_id) AS channels
    , COUNT(DISTINCT the_game) the_game
    , SUM(hw_with_blessed_extension) hw_with_blessed_extension
    , SUM(total_hw) total_hw
    , COUNT(DISTINCT the_extension_id_array) AS extension_array
  FROM dx_sandbox.extension_content_matched_metric
  WHERE the_day>='2019-07-01'
    AND the_day<='2019-07-31'
    AND flag_ugc_oo_channel='UGC Channel'
    --AND flag_ugc_oo_channel='O&O Channel'
  GROUP BY 1 ORDER BY 1
)

SELECT
the_day, f_numeral_format(rows, 'number',0) AS rows
, f_numeral_format(channels, 'number',0) AS channels
, f_numeral_format(the_game, 'number',0) AS the_game
, f_numeral_format(hw_with_blessed_extension, 'number',0) AS hw_with_blessed_extension
, f_numeral_format(total_hw, 'number',0) AS total_hw
, f_numeral_format(extension_array, 'number',0) AS extension_array
FROM the_data
;



WITH the_data AS (
  SELECT the_day::DATE, COUNT(1) AS rows, COUNT(DISTINCT channel_id) AS channels
  , COUNT(DISTINCT the_game) the_game
  , SUM(hw_with_blessed_extension) hw_with_blessed_extension, SUM(total_hw) total_hw
  FROM dx_rollup.extension_content_matched_metric
  WHERE the_day>='2019-07-01'
    AND the_day<='2019-07-31'
    AND flag_ugc_oo_channel='UGC Channel'
    --AND flag_ugc_oo_channel='O&O Channel'
  GROUP BY 1 ORDER BY 1
)
SELECT
the_day, f_numeral_format(rows, 'number',0) AS rows
, f_numeral_format(channels, 'number',0) AS channels
, f_numeral_format(the_game, 'number',0) AS the_game
, f_numeral_format(hw_with_blessed_extension, 'number',0) AS hw_with_blessed_extension
, f_numeral_format(total_hw, 'number',0) AS total_hw

FROM the_data
;


SELECT the_extension_id_array, the_extension_name_array, COUNT(DISTINCT channel_id) AS channels, COUNT(1) AS rows
FROM dx_sandbox.extension_content_matched_metric
WHERE the_day>='2019-07-01'
  AND the_day<='2019-07-31'
  --AND flag_ugc_oo_channel='UGC Channel'
  --AND flag_ugc_oo_channel='O&O Channel'
  AND the_extension_id_array IS NOT NULL
GROUP BY 1,2 ORDER BY 2;

-- ALTER TABLE dx_sandbox.extension_content_matched_metric
-- RENAME game_flattened to the_game;
