-- tahoe.extension_render, tahoe.extension_view , tahoe.extension_click




-- DROP TABLE IF EXISTS dx_rollup.extension_web_viewer_funnel_daily;
--
-- CREATE TABLE IF NOT EXISTS dx_rollup.extension_web_viewer_funnel_daily (
-- the_day                                TIMESTAMP WITHOUT TIME ZONE sortkey
-- ,extension_id                          VARCHAR(32) distkey
-- ,action                                VARCHAR(6)
-- ,unique_devices_web                    BIGINT
-- ,unique_devices_web_video              BIGINT
-- ,unique_devices_web_component          BIGINT
-- ,unique_devices_web_panel              BIGINT
-- );

CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.extension_web_viewer_funnel_daily);

PREPARE the_insert_function_extension_web_viewer_funnel_daily (BIGINT) AS
INSERT INTO the_temp_table(

  -- get the day to insert
  WITH
  the_parameter_constants AS (
    SELECT
    DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as start_day,
    DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) + interval '1 day' as end_day
    --$1::timestamp as start_day
  ),

  -- get channels with which extensions activated per day
  channel_with_extension_daily AS (
  SELECT distinct the_day, channel_id, extension_id, extension_anchor, bool_extension_activated
  FROM dx_rollup.extension_daily_channel_presence a
  JOIN the_parameter_constants b on a.the_day >= b.start_day and a.the_day < b.end_day
  WHERE
  bool_extension_activated = TRUE
),

-- get device that rendered given extension on given channel
--video, component and panel
extension_render AS (
  select
  date_trunc('day',time) as dt
  ,r.channel_id
  ,r.extension_id
  ,r.extension_anchor
  ,r.device_id
  ,r.platform
  ,'render' as action
  from tahoe.extension_render r
  JOIN the_parameter_constants b on r.time >= b.start_day and r.time < b.end_day
  -- render has to have existed on channel that day
  JOIN channel_with_extension_daily ced on r.time >= ced.the_day and r.time < ced.the_day + interval '1 day'
                                        and r.extension_id = ced.extension_id and r.channel_id = ced.channel_id
                                        and r.extension_anchor = ced.extension_anchor
  WHERE
  r.extension_anchor != 'NULL_EXTENSION_ANCHOR'
  and r.extension_anchor is not null
  and r.date >= b.start_day and r.date < b.end_day
  and r.extension_mode not in ('dashboard', 'config')
),

-- get device that viewed given extension on given channel
-- video and component extensions are automatically viewed
extension_view AS (
  select
  date_trunc('day',time) as dt
  ,v.channel_id
  ,v.extension_id
  ,v.extension_anchor
  ,v.device_id
  ,v.platform
  ,'view' as action
  from tahoe.extension_view v
  JOIN the_parameter_constants b on v.time >= b.start_day and v.time < b.end_day
  -- to view, device has to have rendered on same day
  join extension_render r on v.time >= r.dt and v.time < r.dt + interval '1 day'
                          and r.device_id = v.device_id
                          and r.extension_id = v.extension_id
                          and r.channel_id = v.channel_id
                          and r.extension_anchor = v.extension_anchor
  WHERE
  v.extension_anchor != 'NULL_EXTENSION_ANCHOR'
  and v.extension_anchor is not null
  and v.extension_anchor = 'panel'
  and v.date >= b.start_day and v.date < b.end_day
  and v.extension_mode not in ('dashboard', 'config')

  union

  select dt,
  channel_id,
  extension_id,
  extension_anchor,
  device_id,
  platform,
  'view' as action
  from extension_render
  where extension_anchor in ('component', 'video_overlay')
),

extension_click AS (
  select
  date_trunc('day',time) as dt
  ,c.channel_id
  ,c.extension_id
  ,c.extension_anchor
  ,c.device_id
  ,c.platform
  ,'click' as action
  from tahoe.extension_click c
  JOIN the_parameter_constants b on c.time >= b.start_day and c.time < b.end_day
  join extension_view v on c.time >= v.dt and c.time < v.dt + interval '1 day'
                          and v.device_id = c.device_id
                          and v.extension_id = c.extension_id
                          and v.channel_id = c.channel_id
                          and v.extension_anchor = c.extension_anchor
  WHERE
  c.extension_anchor != 'NULL_EXTENSION_ANCHOR'
  and c.extension_anchor is not null
  and c.date >= b.start_day and c.date < b.end_day
  and c.extension_mode not in ('dashboard', 'config')
),
render_web as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web
   from extension_render
   where platform = 'web'
   group by 1,2
),
render_web_panel as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web_panel
   from extension_render
   where platform = 'web'
   and extension_anchor = 'panel'
   group by 1,2
),
render_web_component as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web_component
   from extension_render
   where platform = 'web'
   and extension_anchor = 'component'
   group by 1,2
),
render_web_video as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web_video
   from extension_render
   where platform = 'web'
   and extension_anchor = 'video_overlay'
   group by 1,2
),
render_log as (
  select
  w.dt,
  w.extension_id,
  'render' as action,
  unique_devices_web,
  unique_devices_web_video,
  unique_devices_web_component,
  unique_devices_web_panel
  from render_web w
  left join render_web_video v on w.dt = v.dt and w.extension_id = v.extension_id
  left join render_web_component c on w.dt = c.dt and w.extension_id = c.extension_id
  left join render_web_panel p on w.dt = p.dt and w.extension_id = p.extension_id
),
--view

view_web as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web
   from extension_view
   where platform = 'web'
   group by 1,2
),
view_web_panel as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web_panel
   from extension_view
   where platform = 'web'
   and extension_anchor = 'panel'
   group by 1,2
),
view_web_component as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web_component
   from extension_view
   where platform = 'web'
   and extension_anchor = 'component'
   group by 1,2
),
view_web_video as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web_video
   from extension_view
   where platform = 'web'
   and extension_anchor = 'video_overlay'
   group by 1,2
),
view_log as (
  select
  w.dt,
  w.extension_id,
  'view' as action,
  unique_devices_web,
  unique_devices_web_video,
  unique_devices_web_component,
  unique_devices_web_panel
  from view_web w
  left join view_web_video v on w.dt = v.dt and w.extension_id = v.extension_id
  left join view_web_component c on w.dt = c.dt and w.extension_id = c.extension_id
  left join view_web_panel p on w.dt = p.dt and w.extension_id = p.extension_id
),
-- clicks
click_web as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web
   from extension_click
   where platform = 'web'
   group by 1,2
),
click_web_panel as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web_panel
   from extension_click
   where platform = 'web'
   and extension_anchor = 'panel'
   group by 1,2
),
click_web_component as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web_component
   from extension_click
   where platform = 'web'
   and extension_anchor = 'component'
   group by 1,2
),
click_web_video as (
  select dt
  ,extension_id
  ,count(distinct device_id) as unique_devices_web_video
   from extension_click
   where platform = 'web'
   and extension_anchor = 'video_overlay'
   group by 1,2
),
click_log as (
  select
  w.dt,
  w.extension_id,
  'click' as action,
  unique_devices_web,
  unique_devices_web_video,
  unique_devices_web_component,
  unique_devices_web_panel
  from click_web w
  left join click_web_video v on w.dt = v.dt and w.extension_id = v.extension_id
  left join click_web_component c on w.dt = c.dt and w.extension_id = c.extension_id
  left join click_web_panel p on w.dt = p.dt and w.extension_id = p.extension_id
)
select * from render_log
union
select * from view_log
union
select * from click_log
);


--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_extension_web_viewer_funnel_daily (BIGINT) AS
DELETE FROM dx_rollup.extension_web_viewer_funnel_daily
WHERE date_trunc('day', dx_rollup.extension_web_viewer_funnel_daily.the_day) = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')))
;

--RUN THE INSERT FUNCTIONS BY ITERATING OVER DIFFERENT VALUES





EXECUTE the_insert_function_extension_web_viewer_funnel_daily (-2);
EXECUTE the_delete_function_extension_web_viewer_funnel_daily (-2);
INSERT INTO dx_rollup.extension_web_viewer_funnel_daily (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function_extension_web_viewer_funnel_daily (-1);
EXECUTE the_delete_function_extension_web_viewer_funnel_daily (-1);
INSERT INTO dx_rollup.extension_web_viewer_funnel_daily (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;







-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function_extension_web_viewer_funnel_daily;
DEALLOCATE the_delete_function_extension_web_viewer_funnel_daily;
