-- This is a template for unit test
-- Must return 1 row only per unit test check
-- so create multiple sql files for different tests

-- Put the sql file in    /home/airflow/files_testing     in coconut_box
-- the name of the sql file can be anything


-------------------------------
-- SCHEMA OF UNIT TEST TABLE --
-------------------------------
-- the_day (DATE)
-- slack_ldap (varchar)
-- flag_send_when_pass (bool)
-- flag_send_when_fail (bool)
-- logic_description (varchar)
-- bool_pass_fail (bool)
-- logic_pass_fail (custom varchar formatted for slack)     :white_check_mark: PASS        :x: FAIL
-- tables_used (varchar)
-------------------------------





WITH

--------------------------------------------------------------
-- UPDATE SOME CONSTANT VALUES  (START)                     --
-- NOTE: search for the string --->   change the value here --
--------------------------------------------------------------

------------------------------------------------------------------------------
-- THIS IS YOUR SLACK LDAP (NOTE: NOT YOUR CUSTOM SLACK NAME BUT YOUR LDAP) --
------------------------------------------------------------------------------
the_constants_slack_ldap AS (SELECT
  'yanghung' --change the value here
  ::VARCHAR(25) --leave this here unchanged since we are casting the data type explicitly
AS slack_ldap)



-------------------------------------------------------------------------------
-- TRUE IF YOU WANT TO SEND A MESSAGE WHEN THE CHECK PASSES, OTHERWISE FALSE --
-------------------------------------------------------------------------------
, the_constants_flag_send_when_pass AS (SELECT
  TRUE --change the value here, either   TRUE   or   FALSE
  ::BOOLEAN --leave this here unchanged since we are casting the data type explicitly
AS flag_send_when_pass)


------------------------------------------------------------------------------
-- TRUE IF YOU WANT TO SEND A MESSAGE WHEN THE CHECK FAILS, OTHERWISE FALSE --
------------------------------------------------------------------------------
, the_constants_flag_send_when_fail AS (SELECT
  FALSE --change the value here, either   TRUE   or   FALSE
  ::BOOLEAN --leave this here unchanged since we are casting the data type explicitly
AS flag_send_when_fail)


-------------------------------------------------------
-- THIS IS THE NAME OF THE TABLE(S) YOU ARE CHECKING --
-------------------------------------------------------
, the_constants_tables_used AS (SELECT
  'dx_rollup.cool_table1, dx_metadata.awesome_table2' --change the value here
  ::VARCHAR(500) --leave this here unchanged since we are casting the data type explicitly
AS tables_used)


---------------------------------------------------------------
-- THIS IS A HUMAN DESCRIPTION OF THE LOGIC YOU ARE CHECKING --
---------------------------------------------------------------
, the_constants_logic_description AS (SELECT
  'Check whether or not we have reached a milestone in the metric' --change the value here
  ::VARCHAR(1000) --leave this here unchanged since we are casting the data type explicitly
AS logic_description)




---------------------------------------
-- UPDATE SOME CONSTANT VALUES (END) --
----------------------------------------









------------------------------------------
-- UPDATE YOUR LOGIC CHECK HERE (START) --
------------------------------------------
, the_data AS (
  --extension_content_matched_metric_by_day
  SELECT the_day
    , COUNT(1) AS rows
    , COUNT(DISTINCT channel_id) AS channels
  FROM dx_rollup.extension_content_matched_metric AS base
  WHERE
    the_day>=(SELECT MIN(the_day) FROM dx_metadata.rolling_7_days)
    AND the_day<=(SELECT MAX(the_day) FROM dx_metadata.rolling_7_days)
  GROUP BY 1
)
, final_data AS (
  SELECT base.the_day, the_data.rows, the_data.channels
    , CASE
        WHEN the_data.rows > 0 THEN TRUE -- if rows >0 then TRUE i.e. it passed
        ELSE FALSE -- ELSE false i.e. not passed
      END AS flag_individual_boolean -- keep this col name to be "flag_individual_boolean"
  FROM dx_metadata.rolling_7_days AS base
  LEFT JOIN the_data ON base.the_day = the_data.the_day
)


----------------------------------------------------------------------------------
-- WE MUST RETURN 1 BOOLEAN VALUE OF TRUE/FALSE HERE AND NAME IT bool_pass_fail --
----------------------------------------------------------------------------------
, logic_final AS (
  -- BOOL_AND is the intersect of each individual TRUE/FALSE
  SELECT BOOL_AND(flag_individual_boolean) AS bool_pass_fail -- you can keep this line as long as you kept col name "flag_individual_boolean"
  FROM final_data -- update your table name here
)



----------------------------------------
-- UPDATE YOUR LOGIC CHECK HERE (END) --
----------------------------------------










-----------------------------------------------------------------------------------
-- YOU DONT NEED TO CHANGE THESE SINCE THEY REFERENCE YOUR CHANGES IN CODE ABOVE --
-----------------------------------------------------------------------------------
, final_unit_test AS (
  SELECT
    (SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE) AS the_day
    , (SELECT slack_ldap FROM the_constants_slack_ldap) AS slack_ldap
    , (SELECT flag_send_when_fail FROM the_constants_flag_send_when_fail) AS flag_send_when_fail
    , (SELECT flag_send_when_pass FROM the_constants_flag_send_when_pass) AS flag_send_when_pass
    , (SELECT logic_description FROM the_constants_logic_description) AS logic_description
    , bool_pass_fail
    , CASE WHEN bool_pass_fail = TRUE THEN ':white_check_mark: PASS'::VARCHAR(25) ELSE ':x: FAIL'::VARCHAR(25) END AS logic_pass_fail_slack_string
    , (SELECT tables_used FROM the_constants_tables_used) AS tables_used


  FROM logic_final
)
SELECT * FROM final_unit_test;
