-- This is a template for unit test
-- Must return 1 row only per unit test check
-- so create multiple sql files for different tests

-- Put the sql file in    /home/airflow/files_testing     in coconut_box
-- the name of the sql file can be anything


-------------------------------
-- SCHEMA OF UNIT TEST TABLE --
-------------------------------
-- the_day
-- table_name
-- logic_description
-- bool_pass_fail
-------------------------------




WITH

----------------------------------------------
-- UPDATE SOME CONSTANT VALUES HERE (START) --
----------------------------------------------
the_constants AS (
  SELECT

    ----------------------------------------------------
    -- THIS IS THE NAME OF THE TABLE YOU ARE CHECKING --
    ----------------------------------------------------
    'dx_rollup.extension_content_matched_metric' AS table_name
    ----------------------------------------------------
    ----------------------------------------------------


    ---------------------------------------------------------------
    -- THIS IS A HUMAN DESCRIPTION OF THE LOGIC YOU ARE CHECKING --
    ---------------------------------------------------------------
    , 'Has data for the most recent 7 days' AS logic_description
    ---------------------------------------------------------------
    ---------------------------------------------------------------



    , DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) ::DATE AS todays_day -- dont need to change this
)
--------------------------------------------
-- UPDATE SOME CONSTANT VALUES HERE (END) --
--------------------------------------------




------------------------------------------
-- UPDATE YOUR LOGIC CHECK HERE (START) --
------------------------------------------
, the_data AS (
  --extension_content_matched_metric_by_day
  SELECT the_day
    , COUNT(1) AS rows
    , COUNT(DISTINCT channel_id) AS channels
  FROM dx_rollup.extension_content_matched_metric AS base
  WHERE
    the_day>=(SELECT MIN(the_day) FROM dx_metadata.rolling_7_days)
    AND the_day<=(SELECT MAX(the_day) FROM dx_metadata.rolling_7_days)
  GROUP BY 1
)
, final_data AS (
  SELECT base.the_day, the_data.rows, the_data.channels
    , CASE
        WHEN the_data.rows > 0 THEN TRUE -- if rows >0 then TRUE i.e. it passed
        ELSE FALSE -- ELSE false i.e. not passed
      END AS flag_individual_boolean -- keep this col name to be "flag_individual_boolean"
  FROM dx_metadata.rolling_7_days AS base
  LEFT JOIN the_data ON base.the_day = the_data.the_day
)


----------------------------------------------------------------------------------
-- WE MUST RETURN 1 BOOLEAN VALUE OF TRUE/FALSE HERE AND NAME IT bool_pass_fail --
----------------------------------------------------------------------------------
, logic_final AS (
  -- BOOL_AND is the intersect of each individual TRUE/FALSE
  SELECT BOOL_AND(flag_individual_boolean) AS bool_pass_fail -- you can keep this line as long as you kept col name "flag_individual_boolean"
  FROM final_data -- update your table name here
)



----------------------------------------
-- UPDATE YOUR LOGIC CHECK HERE (END) --
----------------------------------------










-----------------------------------------------------------------------------------
-- YOU DONT NEED TO CHANGE THESE SINCE THEY REFERENCE YOUR CHANGES IN CODE ABOVE --
-----------------------------------------------------------------------------------
, final_unit_test AS (
  SELECT
    (SELECT todays_day FROM the_constants) AS the_day
    , (SELECT table_name FROM the_constants) AS table_name
    , (SELECT logic_description FROM the_constants) AS logic_description
    , bool_pass_fail
  FROM logic_final
)
SELECT * FROM final_unit_test;
