
DROP TABLE IF EXISTS dx_sandbox.released_extensions_latest;

CREATE TABLE dx_sandbox.released_extensions_latest AS





WITH

extensions_metadata_helper_extension_state_latest AS (
  SELECT extension_id, extension_version
  FROM dx_sandbox.extensions_metadata_helper_extension_state_latest
  WHERE the_day = DATEADD('day', -1,  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )
  AND extension_state = 'released'
)

, final_data AS (
  SELECT
    base.extension_id, base.extension_version, extension_name
    , extension_category_id, extension_category_name, extension_author_name, extension_support_email, extension_url
    , is_bits_enabled, is_chat_enabled, is_overlay_enabled, is_component_enabled, is_panel_enabled
    , is_mobile_enabled, is_android_enabled, is_ios_enabled, is_viewer_identity_required, is_whitelisted_extension, whitelist_channels
  FROM extensions_metadata_helper_extension_state_latest AS base
  LEFT JOIN dx_sandbox.extensions_metadata_helper_metadata_main AS mm ON
    base.extension_id = mm.extension_id
    AND base.extension_version = mm.extension_version
)


SELECT * FROM final_data
;
