DROP TABLE IF EXISTS the_temp_table; -- just in case there's a duplicate named table called "the_temp_table" since we often reuse this name
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.extensions_metadata_helper_extension_state_latest);

INSERT INTO the_temp_table (




  WITH


  --keep the columns we need
  extensions_metadata_helper_all_version_state AS (
    SELECT the_day, extension_id, extension_version
      --  if bool_deleted = TRUE, then hard code the state to deleted
      , CASE
          WHEN bool_deleted = TRUE THEN 'deleted'
          ELSE extension_state
        END AS extension_state
      , recent_released_version
      , bool_deleted
    FROM dx_sandbox.extensions_metadata_helper_all_version_state
    WHERE the_day = DATEADD('day', -1,  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )
  )

  -- do the complicated logic to determine the rank of the row (each row is a unique extension_id + extension_version)
  , extension_version_state2 AS (
    SELECT *

    , CASE
      -- not deleted extension AND it has a valid recent_released_version record, then take the row that's released
      WHEN extension_state = 'released'
        AND recent_released_version IS NOT NULL
        AND bool_deleted = FALSE THEN 0

      -- there are weird records where bool_deleted = FALSE but it only has 1 record
      -- where the extension_state is 'deleted', so we split it out like this
      WHEN bool_deleted = TRUE THEN 1
      WHEN extension_state = 'deleted'  THEN 2

      -- favor rejected over approved? since if its approved it will likely go to released right away?
      WHEN extension_state = 'rejected' THEN 4
      WHEN extension_state = 'approved' THEN 5

      -- these are in between states
      WHEN extension_state = 'pending_action' THEN 6
      WHEN extension_state = 'review' THEN 7
      WHEN extension_state = 'ready_for_review' THEN 8
      WHEN extension_state = 'assets_uploaded' THEN 9
      WHEN extension_state = 'uploading' THEN 10

      -- these are lowest priority
      WHEN extension_state = 'test' THEN 98
      WHEN extension_state = 'deprecated' THEN 99
    END as the_rank_logic

    FROM extensions_metadata_helper_all_version_state
  )

  --get the ranking of extension_state and calculate the min rank for each extension_id to get the latest working version
  -- the_day, extension_id, extension_version, extension_state, recent_released_version, bool_deleted, the_rank_logic, the_min_rank
  , extension_version_state3 AS (
    SELECT base.*, MIN(the_rank_logic) OVER (PARTITION BY extension_id) AS the_min_rank
    FROM extension_version_state2 AS base
  )
  -- ensure there is one row per extension_id
  , the_final_data AS (
    SELECT the_day, extension_id, MAX(extension_state) AS extension_state
      , MAX(CASE
          WHEN extension_state = 'released' THEN recent_released_version
          ELSE extension_version
        END) AS extension_version
    FROM extension_version_state3
    WHERE the_rank_logic = the_min_rank
    GROUP BY 1,2
  )

  SELECT the_day, extension_id::VARCHAR(32), extension_version::VARCHAR(50), extension_state::VARCHAR(50)
  FROM the_final_data



);


DELETE FROM dx_sandbox.extensions_metadata_helper_extension_state_latest
WHERE the_day = DATEADD('day', -1,  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )
;



INSERT INTO dx_sandbox.extensions_metadata_helper_extension_state_latest (
  SELECT * FROM the_temp_table
);
