--NOTE: AS OF 2019-11-08, only have data for desktop app and web
-- so search for the string below to change if tracking event changes
-- LOWER(base.platform) IN ('desktop', 'web') --exclude mobile_web since its incorrect data

--NOTE: create a table to support the "numerator" of the cme metric
--SPEC FOR ---> dx_sandbox.metric_cme_helper_hw_with_extension
-- the_day
-- channel_id
-- the_game
-- platform
-- flag_ugc_oo_channel
-- extension_id
-- flag_extension_count_towards_cme
-- hw_with_extension


-- --Create the Table with explicit schema types  NOTE: IF NOT EXISTS IS AN OPTIONAL KEYWORD
-- CREATE TABLE IF NOT EXISTS dx_sandbox.metric_cme_helper_hw_with_extension (
--     the_day                                 DATE sortkey
--     , channel_id                            BIGINT
--     , the_game                              VARCHAR(500) distkey
--     , platform                              VARCHAR(50)
--     , flag_ugc_oo_channel                   VARCHAR(25)
--     , extension_id                          VARCHAR(32)
--     , flag_extension_count_towards_cme      BOOLEAN
--     , hw_with_extension                     FLOAT
-- );



-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_metric_cme_helper_hw_with_extension (BIGINT) AS
DELETE FROM dx_sandbox.metric_cme_helper_hw_with_extension
WHERE the_day = DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  )
;


--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.metric_cme_helper_hw_with_extension);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_metric_cme_helper_hw_with_extension (BIGINT) AS
INSERT INTO the_temp_table (



  WITH
  the_parameter_input AS (
    SELECT DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  ) AS the_day_to_refresh_data_for
  )
  , the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT the_day_to_refresh_data_for AS start_date FROM the_parameter_input)
  )
  , extension_daily_mw AS (
    SELECT base.the_day
    , base.channel_id
    , f_game_flattened(base.game) As the_game
    , base.platform
    , base.extension_id
    , SUM(base.mw::FLOAT/60) AS hw
    FROM cubes.extension_daily_mw AS base
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
      AND LOWER(base.platform) IN ('desktop', 'web') --exclude mobile_web since its incorrect data
      AND base.channel_id IS NOT NULL
      AND game IS NOT NULL
    GROUP BY 1,2,3,4,5
  )
  , channel_daily_status AS (
    SELECT the_date, channel_id, tier, CASE WHEN tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel
    FROM cubes.channel_daily_status
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_date AND the_date<(SELECT end_date FROM the_constants_time)
    GROUP BY 1,2,3,4
  )
  , join_data AS (
    SELECT base.the_day
    , base.channel_id
    , base.the_game
    , base.platform
    , base.extension_id
    , NVL(cds.tier, 'NULL: NOT STREAM LAST 30 DAYS') AS tier
    , NVL(cds.flag_ugc_oo_channel, 'UGC Channel') AS flag_ugc_oo_channel
    , base.hw
    FROM extension_daily_mw AS base
    LEFT JOIN channel_daily_status AS cds ON base.the_day = cds.the_date AND base.channel_id = cds.channel_id
  )




  , final_data AS (
    SELECT
      the_day::DATE
      , channel_id::BIGINT
      , the_game::VARCHAR
      , platform::VARCHAR
      , flag_ugc_oo_channel::VARCHAR
      , base.extension_id::VARCHAR
      , CASE
          WHEN flag_ugc_oo_channel = 'UGC Channel' AND base.the_game = ext.game_flattened AND base.extension_id = ext.extension_id
          THEN flag_count_cme_ugc

          WHEN flag_ugc_oo_channel = 'O&O Channel' AND base.extension_id = ext.extension_id
          THEN flag_count_cme_premium

          ELSE FALSE
        END AS flag_extension_count_towards_cme
      , base.hw::FLOAT
    FROM join_data AS base
    LEFT JOIN dx_sandbox.metric_cme_helper_extension_list AS ext ON base.extension_id = ext.extension_id
  )


  SELECT * FROM final_data



);



--RUN INSERT AND DELETE



EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-1); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-1);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-2); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-2);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-3); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-3);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-4); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-4);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-5); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-5);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-6); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-6);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-7); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-7);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-8); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-8);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-9); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-9);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-10); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-10);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-11); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-11);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-12); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-12);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-13); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-13);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-14); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-14);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-15); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-15);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-16); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-16);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-17); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-17);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-18); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-18);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-19); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-19);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;


EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-20); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-20);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-21); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-21);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-22); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-22);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-23); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-23);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-24); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-24);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-25); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-25);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-26); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-26);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-27); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-27);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-28); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-28);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-29); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-29);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;


EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-30); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-30);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-31); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-31);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-32); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-32);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-33); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-33);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-34); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-34);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-35); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-35);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-36); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-36);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-37); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-37);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-38); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-38);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-39); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-39);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;


EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-40); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-40);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-41); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-41);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-42); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-42);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-43); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-43);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-44); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-44);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-45); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-45);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-46); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-46);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-47); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-47);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-48); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-48);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-49); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-49);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-50); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-50);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-51); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-51);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-52); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-52);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-53); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-53);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-54); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-54);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-55); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-55);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-56); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-56);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-57); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-57);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-58); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-58);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-59); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-59);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-60); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-60);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-61); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-61);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-62); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-62);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-63); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-63);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-64); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-64);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-65); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-65);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-66); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-66);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-67); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-67);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-68); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-68);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-69); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-69);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-70); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-70);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-71); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-71);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-72); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-72);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-73); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-73);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-74); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-74);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-75); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-75);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-76); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-76);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-77); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-77);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-78); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-78);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-79); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-79);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-80); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-80);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-81); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-81);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-82); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-82);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-83); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-83);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-84); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-84);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-85); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-85);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-86); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-86);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-87); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-87);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-88); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-88);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-89); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-89);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
