--NOTE: AS OF 2019-11-08, only have data for desktop app and web
-- so search for the string below to change if tracking event changes
-- LOWER(base.platform) IN ('desktop', 'web') --exclude mobile_web since its incorrect data


-- NOTE: ORIGINAL SPEC ---> dx_rollup.extension_content_matched_metric
-- the_day	timestamp
-- channel_id	bigint
-- the_extension_id_array varchar(max)
-- the_extension_name_array varchar(max)
-- the_game	varchar(255)
-- platform	varchar(255)
-- flag_ugc_oo_channel	varchar(255)
-- hw_with_blessed_extension	double precision
-- total_hw	double precision
-- pct_hw_with_blessed_extension	double precision



--NOTE: SPEC FOR ---> dx_rollup.metric_cme
-- the_day
-- channel_id
-- the_game
-- platform
-- flag_ugc_oo_channel
-- extension_id_array_cmes
-- extension_name_array_cmes
-- extension_id_array_not_cmes
-- extension_name_array_not_cmes
-- hw_with_cmes
-- total_hw



--
-- --Create the Table with explicit schema types  NOTE: IF NOT EXISTS IS AN OPTIONAL KEYWORD
-- CREATE TABLE IF NOT EXISTS dx_sandbox.metric_cme (
--     the_day                           DATE sortkey
--     , channel_id                      BIGINT
--     , the_game                        VARCHAR(500) distkey
--     , platform                        VARCHAR(50)
--     , flag_ugc_oo_channel             VARCHAR(25)
--     , extension_id_array_cmes         VARCHAR(65535)
--     , extension_name_array_cmes       VARCHAR(65535)
--     , extension_id_array_not_cmes     VARCHAR(65535)
--     , extension_name_array_not_cmes   VARCHAR(65535)
--     , hw_with_cmes                    FLOAT
--     , total_hw                        FLOAT
-- );



-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_metric_cme (BIGINT) AS
DELETE FROM dx_sandbox.metric_cme
WHERE the_day = DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  )
;


--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.metric_cme);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_metric_cme (BIGINT) AS
INSERT INTO the_temp_table (



  WITH
  the_parameter_input AS (
    SELECT DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  ) AS the_day_to_refresh_data_for
  )
  , the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT the_day_to_refresh_data_for AS start_date FROM the_parameter_input)
  )
  --get channel_daily_status data
  , channel_daily_status AS (
    SELECT the_date, channel_id, tier, CASE WHEN tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel
    FROM cubes.channel_daily_status
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_date AND the_date<(SELECT end_date FROM the_constants_time)
    GROUP BY 1,2,3,4
  )
  --get the data for denominator (total_hw)
  , metric_cme_helper_denominator_total_hw AS (
    SELECT
      the_day, channel_id, the_game, platform --the join fields
      , total_hw
    FROM dx_sandbox.metric_cme_helper_denominator_total_hw
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
  )
  --get the data for numerator (extension hw) desktop and web platforms only
  , metric_cme_helper_hw_with_extension AS (
    SELECT the_day, channel_id, the_game, platform, base.extension_id, extension_name, flag_extension_count_towards_cme, hw_with_extension
    FROM dx_sandbox.metric_cme_helper_hw_with_extension AS base
    LEFT JOIN dx_metadata.all_extensions_latest AS ael ON base.extension_id = ael.extension_id
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
      AND LOWER(base.platform) IN ('desktop', 'web') --exclude mobile_web since its incorrect data
  )



  -- collapse data for extension hw to be one row per the_day, channel_id, the_game, platform, aggregate to get hw_with_cmes
  , metric_cme_helper_hw_with_extension_pt1 AS (
    SELECT the_day, channel_id, the_game, platform --the join fields
      , SUM(CASE WHEN flag_extension_count_towards_cme = TRUE THEN hw_with_extension ELSE 0 END) AS hw_with_cmes
    FROM metric_cme_helper_hw_with_extension
    GROUP BY 1,2,3,4
  )
  --generate the json array for array_cmes
  , metric_cme_helper_hw_with_extension_pt2 AS (
    SELECT the_day, channel_id, the_game, platform --the join fields
      , listagg('"'||extension_id||'"', ',') WITHIN GROUP (ORDER BY extension_name) AS extension_id_list_cmes
      , listagg('"'||extension_name||'"', ',') WITHIN GROUP (ORDER BY extension_name) AS extension_name_list_cmes
    FROM metric_cme_helper_hw_with_extension
    WHERE flag_extension_count_towards_cme = TRUE -- take only records where it is counted towards cme
    GROUP BY 1,2,3,4
  )
  --generate the json array for array_not_cmes
  , metric_cme_helper_hw_with_extension_pt3 AS (
    SELECT the_day, channel_id, the_game, platform --the join fields
      , listagg('"'||extension_id||'"', ',') WITHIN GROUP (ORDER BY extension_name) AS extension_id_list_not_cmes
      , listagg('"'||extension_name||'"', ',') WITHIN GROUP (ORDER BY extension_name) AS extension_name_list_not_cmes
    FROM metric_cme_helper_hw_with_extension
    WHERE flag_extension_count_towards_cme = FALSE -- take only records where it is not counted towards cme
    GROUP BY 1,2,3,4
  )


  --get the data for numerator (extension hw) non desktop non web platforms
  , metric_cme_helper_hw_with_extension_non_web_non_desktop AS (
    SELECT the_day, channel_id, the_game, platform --the join fields
      , the_extension_id_array AS extension_id_array_cmes
      , the_extension_name_array AS extension_name_array_cmes
      , '[]' AS extension_id_array_not_cmes
      , '[]' AS extension_name_array_not_cmes
      , hw_with_blessed_extension AS hw_with_cmes
    FROM dx_rollup.extension_content_matched_metric AS base
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
      AND LOWER(base.platform) NOT IN ('desktop', 'web') --exclude mobile_web since its incorrect data
  )

  --join together all the fields to make metric_cme_helper_hw_with_extension_final (your numerator portion)
  , metric_cme_helper_hw_with_extension_web_desktop_only AS (
    SELECT pt1.the_day, pt1.channel_id, pt1.the_game, pt1.platform --the join fields
      , '['||extension_id_list_cmes||']' AS extension_id_array_cmes
      , '['||extension_name_list_cmes||']' AS extension_name_array_cmes
      , '['||extension_id_list_not_cmes||']' AS extension_id_array_not_cmes
      , '['||extension_name_list_not_cmes||']' AS extension_name_array_not_cmes
      , hw_with_cmes
    FROM metric_cme_helper_hw_with_extension_pt1 AS pt1
    LEFT JOIN metric_cme_helper_hw_with_extension_pt2 AS pt2 ON pt1.the_day = pt2.the_day AND pt1.channel_id = pt2.channel_id AND pt1.the_game = pt2.the_game AND pt1.platform = pt2.platform
    LEFT JOIN metric_cme_helper_hw_with_extension_pt3 AS pt3 ON pt1.the_day = pt3.the_day AND pt1.channel_id = pt3.channel_id AND pt1.the_game = pt3.the_game AND pt1.platform = pt3.platform
  )

  --UNION the two tables to get metric_cme_helper_hw_with_extension_final
  , metric_cme_helper_hw_with_extension_final AS (
    SELECT * FROM metric_cme_helper_hw_with_extension_web_desktop_only
    UNION SELECT * FROM metric_cme_helper_hw_with_extension_non_web_non_desktop
  )

  --join the numerator and denominator CTEs to make final_join
  , final_join AS (
    SELECT base.the_day, base.channel_id, base.the_game, base.platform --the join fields
      , NVL(cds.flag_ugc_oo_channel, 'UGC Channel') AS flag_ugc_oo_channel
      , NVL(ext.extension_id_array_cmes, '[]') AS extension_id_array_cmes --'[]' is a valid json array, cant use NULL
      , NVL(ext.extension_name_array_cmes, '[]') AS extension_name_array_cmes --'[]' is a valid json array, cant use NULL
      , NVL(ext.extension_id_array_not_cmes, '[]') AS extension_id_array_not_cmes --'[]' is a valid json array, cant use NULL
      , NVL(ext.extension_name_array_not_cmes, '[]') AS extension_name_array_not_cmes --'[]' is a valid json array, cant use NULL
      , NVL(ext.hw_with_cmes,0::FLOAT) AS hw_with_cmes --if no records on the join then default it to 0 hw with cme
      , base.total_hw
    FROM metric_cme_helper_denominator_total_hw AS base --this should have the most rows since you can stream without extensions
    LEFT JOIN channel_daily_status AS cds ON base.the_day = cds.the_date AND base.channel_id = cds.channel_id
    LEFT JOIN metric_cme_helper_hw_with_extension_final AS ext ON base.the_day = ext.the_day AND base.channel_id = ext.channel_id AND base.the_game = ext.the_game AND base.platform = ext.platform
  )

  SELECT * FROM final_join



);





EXECUTE the_insert_function_metric_cme (-1); EXECUTE the_delete_function_metric_cme (-1);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-2); EXECUTE the_delete_function_metric_cme (-2);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-3); EXECUTE the_delete_function_metric_cme (-3);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-4); EXECUTE the_delete_function_metric_cme (-4);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-5); EXECUTE the_delete_function_metric_cme (-5);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-6); EXECUTE the_delete_function_metric_cme (-6);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-7); EXECUTE the_delete_function_metric_cme (-7);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-8); EXECUTE the_delete_function_metric_cme (-8);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-9); EXECUTE the_delete_function_metric_cme (-9);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme (-10); EXECUTE the_delete_function_metric_cme (-10);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-11); EXECUTE the_delete_function_metric_cme (-11);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-12); EXECUTE the_delete_function_metric_cme (-12);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-13); EXECUTE the_delete_function_metric_cme (-13);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-14); EXECUTE the_delete_function_metric_cme (-14);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-15); EXECUTE the_delete_function_metric_cme (-15);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-16); EXECUTE the_delete_function_metric_cme (-16);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-17); EXECUTE the_delete_function_metric_cme (-17);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-18); EXECUTE the_delete_function_metric_cme (-18);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-19); EXECUTE the_delete_function_metric_cme (-19);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme (-20); EXECUTE the_delete_function_metric_cme (-20);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-21); EXECUTE the_delete_function_metric_cme (-21);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-22); EXECUTE the_delete_function_metric_cme (-22);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-23); EXECUTE the_delete_function_metric_cme (-23);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-24); EXECUTE the_delete_function_metric_cme (-24);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-25); EXECUTE the_delete_function_metric_cme (-25);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-26); EXECUTE the_delete_function_metric_cme (-26);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-27); EXECUTE the_delete_function_metric_cme (-27);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-28); EXECUTE the_delete_function_metric_cme (-28);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-29); EXECUTE the_delete_function_metric_cme (-29);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme (-30); EXECUTE the_delete_function_metric_cme (-30);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-31); EXECUTE the_delete_function_metric_cme (-31);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-32); EXECUTE the_delete_function_metric_cme (-32);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-33); EXECUTE the_delete_function_metric_cme (-33);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-34); EXECUTE the_delete_function_metric_cme (-34);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-35); EXECUTE the_delete_function_metric_cme (-35);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-36); EXECUTE the_delete_function_metric_cme (-36);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-37); EXECUTE the_delete_function_metric_cme (-37);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-38); EXECUTE the_delete_function_metric_cme (-38);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-39); EXECUTE the_delete_function_metric_cme (-39);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme (-40); EXECUTE the_delete_function_metric_cme (-40);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-41); EXECUTE the_delete_function_metric_cme (-41);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-42); EXECUTE the_delete_function_metric_cme (-42);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-43); EXECUTE the_delete_function_metric_cme (-43);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-44); EXECUTE the_delete_function_metric_cme (-44);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-45); EXECUTE the_delete_function_metric_cme (-45);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-46); EXECUTE the_delete_function_metric_cme (-46);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-47); EXECUTE the_delete_function_metric_cme (-47);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-48); EXECUTE the_delete_function_metric_cme (-48);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-49); EXECUTE the_delete_function_metric_cme (-49);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme (-50); EXECUTE the_delete_function_metric_cme (-50);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-51); EXECUTE the_delete_function_metric_cme (-51);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-52); EXECUTE the_delete_function_metric_cme (-52);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-53); EXECUTE the_delete_function_metric_cme (-53);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-54); EXECUTE the_delete_function_metric_cme (-54);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-55); EXECUTE the_delete_function_metric_cme (-55);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-56); EXECUTE the_delete_function_metric_cme (-56);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-57); EXECUTE the_delete_function_metric_cme (-57);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-58); EXECUTE the_delete_function_metric_cme (-58);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-59); EXECUTE the_delete_function_metric_cme (-59);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme (-60); EXECUTE the_delete_function_metric_cme (-60);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-61); EXECUTE the_delete_function_metric_cme (-61);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-62); EXECUTE the_delete_function_metric_cme (-62);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-63); EXECUTE the_delete_function_metric_cme (-63);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-64); EXECUTE the_delete_function_metric_cme (-64);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-65); EXECUTE the_delete_function_metric_cme (-65);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-66); EXECUTE the_delete_function_metric_cme (-66);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-67); EXECUTE the_delete_function_metric_cme (-67);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-68); EXECUTE the_delete_function_metric_cme (-68);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-69); EXECUTE the_delete_function_metric_cme (-69);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme (-70); EXECUTE the_delete_function_metric_cme (-70);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-71); EXECUTE the_delete_function_metric_cme (-71);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-72); EXECUTE the_delete_function_metric_cme (-72);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-73); EXECUTE the_delete_function_metric_cme (-73);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-74); EXECUTE the_delete_function_metric_cme (-74);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-75); EXECUTE the_delete_function_metric_cme (-75);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-76); EXECUTE the_delete_function_metric_cme (-76);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-77); EXECUTE the_delete_function_metric_cme (-77);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-78); EXECUTE the_delete_function_metric_cme (-78);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-79); EXECUTE the_delete_function_metric_cme (-79);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;

EXECUTE the_insert_function_metric_cme (-80); EXECUTE the_delete_function_metric_cme (-80);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-81); EXECUTE the_delete_function_metric_cme (-81);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-82); EXECUTE the_delete_function_metric_cme (-82);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-83); EXECUTE the_delete_function_metric_cme (-83);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-84); EXECUTE the_delete_function_metric_cme (-84);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-85); EXECUTE the_delete_function_metric_cme (-85);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-86); EXECUTE the_delete_function_metric_cme (-86);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-87); EXECUTE the_delete_function_metric_cme (-87);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-88); EXECUTE the_delete_function_metric_cme (-88);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-89); EXECUTE the_delete_function_metric_cme (-89);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
