--NOTE: AS OF 2019-11-08, only have data for desktop app and web
-- so search for the string below to change if tracking event changes
-- LOWER(base.platform) IN ('desktop', 'web') --exclude mobile_web since its incorrect data


-- NOTE: ORIGINAL SPEC ---> dx_rollup.extension_content_matched_metric
-- the_day	timestamp
-- channel_id	bigint
-- the_extension_id_array varchar(max)
-- the_extension_name_array varchar(max)
-- the_game	varchar(255)
-- platform	varchar(255)
-- flag_ugc_oo_channel	varchar(255)
-- hw_with_blessed_extension	double precision
-- total_hw	double precision
-- pct_hw_with_blessed_extension	double precision



--NOTE: SPEC FOR ---> dx_rollup.metric_cme
-- the_day
-- channel_id
-- the_game
-- platform
-- flag_ugc_oo_channel
-- extension_id_array_cmes
-- extension_name_array_cmes
-- extension_id_array_not_cmes
-- extension_name_array_not_cmes
-- hw_with_cmes
-- total_hw



--
-- --Create the Table with explicit schema types  NOTE: IF NOT EXISTS IS AN OPTIONAL KEYWORD
-- CREATE TABLE IF NOT EXISTS dx_sandbox.metric_cme (
--     the_day                           DATE sortkey
--     , channel_id                      BIGINT
--     , the_game                        VARCHAR(500) distkey
--     , platform                        VARCHAR(50)
--     , flag_ugc_oo_channel             VARCHAR(25)
--     , extension_id_array_cmes         VARCHAR(65535)
--     , extension_name_array_cmes       VARCHAR(65535)
--     , extension_id_array_not_cmes     VARCHAR(65535)
--     , extension_name_array_not_cmes   VARCHAR(65535)
--     , hw_with_cmes                    FLOAT
--     , total_hw                        FLOAT
-- );



-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_metric_cme (BIGINT) AS
DELETE FROM dx_sandbox.metric_cme
WHERE the_day = DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  )
;


--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.metric_cme);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_metric_cme (BIGINT) AS
INSERT INTO the_temp_table (



  WITH
  the_parameter_input AS (
    SELECT DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  ) AS the_day_to_refresh_data_for
  )
  , the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT the_day_to_refresh_data_for AS start_date FROM the_parameter_input)
  )
  --get channel_daily_status data
  , channel_daily_status AS (
    SELECT the_date, channel_id, tier, CASE WHEN tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel
    FROM cubes.channel_daily_status
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_date AND the_date<(SELECT end_date FROM the_constants_time)
    GROUP BY 1,2,3,4
  )
  --get the data for denominator (total_hw)
  , metric_cme_helper_denominator_total_hw AS (
    SELECT
      the_day, channel_id, the_game, platform --the join fields
      , total_hw
    FROM dx_sandbox.metric_cme_helper_denominator_total_hw
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
  )
  --get the data for numerator (extension hw) desktop and web platforms only
  , metric_cme_helper_hw_with_extension AS (
    SELECT the_day, channel_id, the_game, platform, base.extension_id, extension_name, flag_extension_count_towards_cme, hw_with_extension
    FROM dx_sandbox.metric_cme_helper_hw_with_extension AS base
    LEFT JOIN dx_metadata.all_extensions_latest AS ael ON base.extension_id = ael.extension_id
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
      AND LOWER(base.platform) IN ('desktop', 'web') --exclude mobile_web since its incorrect data
  )



  -- collapse data for extension hw to be one row per the_day, channel_id, the_game, platform, aggregate to get hw_with_cmes
  , metric_cme_helper_hw_with_extension_pt1 AS (
    SELECT the_day, channel_id, the_game, platform --the join fields
      , SUM(CASE WHEN flag_extension_count_towards_cme = TRUE THEN hw_with_extension ELSE 0 END) AS hw_with_cmes
    FROM metric_cme_helper_hw_with_extension
    GROUP BY 1,2,3,4
  )
  --generate the json array for array_cmes
  , metric_cme_helper_hw_with_extension_pt2 AS (
    SELECT the_day, channel_id, the_game, platform --the join fields
      , listagg('"'||extension_id||'"', ',') WITHIN GROUP (ORDER BY extension_name) AS extension_id_list_cmes
      , listagg('"'||extension_name||'"', ',') WITHIN GROUP (ORDER BY extension_name) AS extension_name_list_cmes
    FROM metric_cme_helper_hw_with_extension
    WHERE flag_extension_count_towards_cme = TRUE -- take only records where it is counted towards cme
    GROUP BY 1,2,3,4
  )
  --generate the json array for array_not_cmes
  , metric_cme_helper_hw_with_extension_pt3 AS (
    SELECT the_day, channel_id, the_game, platform --the join fields
      , listagg('"'||extension_id||'"', ',') WITHIN GROUP (ORDER BY extension_name) AS extension_id_list_not_cmes
      , listagg('"'||extension_name||'"', ',') WITHIN GROUP (ORDER BY extension_name) AS extension_name_list_not_cmes
    FROM metric_cme_helper_hw_with_extension
    WHERE flag_extension_count_towards_cme = FALSE -- take only records where it is not counted towards cme
    GROUP BY 1,2,3,4
  )


  --get the data for numerator (extension hw) non desktop non web platforms
  , metric_cme_helper_hw_with_extension_non_web_non_desktop AS (
    SELECT the_day, channel_id, the_game, platform --the join fields
      , the_extension_id_array AS extension_id_array_cmes
      , the_extension_name_array AS extension_name_array_cmes
      , '[]' AS extension_id_array_not_cmes
      , '[]' AS extension_name_array_not_cmes
      , hw_with_blessed_extension AS hw_with_cmes
    FROM dx_rollup.extension_content_matched_metric AS base
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
      AND LOWER(base.platform) NOT IN ('desktop', 'web') --exclude mobile_web since its incorrect data
  )

  --join together all the fields to make metric_cme_helper_hw_with_extension_final (your numerator portion)
  , metric_cme_helper_hw_with_extension_web_desktop_only AS (
    SELECT pt1.the_day, pt1.channel_id, pt1.the_game, pt1.platform --the join fields
      , '['||extension_id_list_cmes||']' AS extension_id_array_cmes
      , '['||extension_name_list_cmes||']' AS extension_name_array_cmes
      , '['||extension_id_list_not_cmes||']' AS extension_id_array_not_cmes
      , '['||extension_name_list_not_cmes||']' AS extension_name_array_not_cmes
      , hw_with_cmes
    FROM metric_cme_helper_hw_with_extension_pt1 AS pt1
    LEFT JOIN metric_cme_helper_hw_with_extension_pt2 AS pt2 ON pt1.the_day = pt2.the_day AND pt1.channel_id = pt2.channel_id AND pt1.the_game = pt2.the_game AND pt1.platform = pt2.platform
    LEFT JOIN metric_cme_helper_hw_with_extension_pt3 AS pt3 ON pt1.the_day = pt3.the_day AND pt1.channel_id = pt3.channel_id AND pt1.the_game = pt3.the_game AND pt1.platform = pt3.platform
  )

  --UNION the two tables to get metric_cme_helper_hw_with_extension_final
  , metric_cme_helper_hw_with_extension_final AS (
    SELECT * FROM metric_cme_helper_hw_with_extension_web_desktop_only
    UNION SELECT * FROM metric_cme_helper_hw_with_extension_non_web_non_desktop
  )

  --join the numerator and denominator CTEs to make final_join
  , final_join AS (
    SELECT base.the_day, base.channel_id, base.the_game, base.platform --the join fields
      , NVL(cds.flag_ugc_oo_channel, 'UGC Channel') AS flag_ugc_oo_channel
      , NVL(ext.extension_id_array_cmes, '[]') AS extension_id_array_cmes --'[]' is a valid json array, cant use NULL
      , NVL(ext.extension_name_array_cmes, '[]') AS extension_name_array_cmes --'[]' is a valid json array, cant use NULL
      , NVL(ext.extension_id_array_not_cmes, '[]') AS extension_id_array_not_cmes --'[]' is a valid json array, cant use NULL
      , NVL(ext.extension_name_array_not_cmes, '[]') AS extension_name_array_not_cmes --'[]' is a valid json array, cant use NULL
      , NVL(ext.hw_with_cmes,0::FLOAT) AS hw_with_cmes --if no records on the join then default it to 0 hw with cme
      , base.total_hw
    FROM metric_cme_helper_denominator_total_hw AS base --this should have the most rows since you can stream without extensions
    LEFT JOIN channel_daily_status AS cds ON base.the_day = cds.the_date AND base.channel_id = cds.channel_id
    LEFT JOIN metric_cme_helper_hw_with_extension_final AS ext ON base.the_day = ext.the_day AND base.channel_id = ext.channel_id AND base.the_game = ext.the_game AND base.platform = ext.platform
  )

  SELECT * FROM final_join



);





EXECUTE the_insert_function_metric_cme (-1); EXECUTE the_delete_function_metric_cme (-1);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-2); EXECUTE the_delete_function_metric_cme (-2);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme (-3); EXECUTE the_delete_function_metric_cme (-3);   INSERT INTO dx_sandbox.metric_cme    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;



--Clean up intermediate helper rollups
DELETE FROM dx_sandbox.metric_cme_helper_denominator_total_hw;
DELETE FROM dx_sandbox.metric_cme_helper_hw_with_extension;
