-- 1. For activated extensions across all channels as of 2017-10-11, what % are panel and what % are overlay?
-- This will inform the importance of panel extensions


WITH
the_timeframe AS (
SELECT '2017-05-24 13:00:00'::timestamp AS start_time
, '2017-10-24 23:59:59'::timestamp AS end_time
)

, render_logs AS (
SELECT rel.extension_anchor, COUNT(1) AS rows
--extension_id, user_id, MAX(time) as last_time_activate
FROM logs.extension_render AS er
RIGHT JOIN analysis.released_extensions_latest AS rel ON er.extension_id = rel.extension_id
WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
GROUP BY 1
)

SELECT * FROM render_logs
