
DELETE FROM dx_metadata.rolling_30_days;  --REMOVE OLD RECORDS

INSERT INTO dx_metadata.rolling_30_days (
  SELECT
    date_table.date::DATE AS the_day
    , base.year::INT
    , date_table.month::INT
    , base.week_number::INT AS week_number_wbr
    , base.start_date::DATE AS start_date_wbr
    , base.end_date::DATE AS end_date_wbr
  FROM dx_metadata.wbr_timeframe AS base
  LEFT JOIN metadata.date AS date_table ON base.start_date<= date_table.date AND date_table.date<= base.end_date
  WHERE date_table.date>=DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '30 days'
  AND date_table.date<DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))
  ORDER BY 1
);

