CREATE TABLE IF NOT EXISTS dx_sandbox.daily_web_extension_viewer_funnel_helper_click (
  dt                                  TIMESTAMP WITHOUT TIME ZONE sortkey
  , channel_id                        BIGINT
  , extension_id                      VARCHAR(32)
  , extension_anchor                  VARCHAR(32)
  , device_id                         VARCHAR(32)
  , platform                          VARCHAR(40)
  , action                            VARCHAR(6)
);

CREATE TEMP TABLE temp_table (LIKE dx_sandbox.daily_web_extension_viewer_funnel_helper_click);

PREPARE the_delete_function_daily_web_extension_viewer_funnel_helper_click (BIGINT) AS
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_click
WHERE dt = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')));

PREPARE the_insert_function_daily_web_extension_viewer_funnel_helper_click (BIGINT) AS
INSERT INTO temp_table (
  WITH the_parameter_constants AS (
    SELECT
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as start_day,
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) + interval '1 day' as end_day
  )

  SELECT
  date_trunc('day',time) as dt
  ,c.channel_id
  ,c.extension_id
  ,c.extension_anchor
  ,c.device_id
  ,c.platform
  ,'click' as action
  FROM tahoe.extension_click c
  JOIN dx_sandbox.daily_web_extension_viewer_funnel_helper_view v on c.time >= v.dt and c.time < v.dt + interval '1 day'
                          and c.device_id = v.device_id
                          and c.extension_id = v.extension_id
                          and c.channel_id = v.channel_id
                          and c.extension_anchor = v.extension_anchor
  WHERE
  c.extension_anchor != 'NULL_EXTENSION_ANCHOR'
  and c.extension_anchor is not null
  and c.date >= (SELECT start_day FROM the_parameter_constants)
  and c.date < (SELECT end_day FROM the_parameter_constants)
  and c.extension_mode not in ('dashboard', 'config')
);

---
EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_click(-2);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_click(-2);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_click
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_click(-1);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_click(-1);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_click
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

DEALLOCATE the_delete_function_daily_web_extension_viewer_funnel_helper_click;
DEALLOCATE the_insert_function_daily_web_extension_viewer_funnel_helper_click;
