CREATE TABLE IF NOT EXISTS dx_sandbox.daily_web_extension_viewer_funnel_helper_view_log (
  dt                                          TIMESTAMP WITHOUT TIME ZONE sortkey
  , extension_id                              VARCHAR(32)
  , action                                    VARCHAR(6)
  , unique_devices_web                        BIGINT
  , unique_devices_web_video                  BIGINT
  , unique_devices_web_component              BIGINT
  , unique_devices_web_panel                  BIGINT
);

CREATE TEMP TABLE temp_table (LIKE dx_sandbox.daily_web_extension_viewer_funnel_helper_view_log);

PREPARE the_delete_function_daily_web_extension_viewer_funnel_helper_view_log (BIGINT) AS
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_view_log
WHERE dt = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')));

PREPARE the_insert_function_daily_web_extension_viewer_funnel_helper_view_log (BIGINT) AS
INSERT INTO temp_table (
  WITH the_parameter_constants AS (
    SELECT
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as start_day,
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) + interval '1 day' as end_day
  ),

  view_web as (
    select dt, extension_id, count(distinct device_id) as unique_devices_web
    from dx_sandbox.daily_web_extension_viewer_funnel_helper_view
    where platform = 'web'
    and dt = (SELECT start_day FROM the_parameter_constants)
    group by 1,2
  )

  , view_web_panel as (
    select dt, extension_id , count(distinct device_id) as unique_devices_web_panel
    from dx_sandbox.daily_web_extension_viewer_funnel_helper_view
    where platform = 'web'
    and extension_anchor = 'panel'
    and dt = (SELECT start_day FROM the_parameter_constants)
    group by 1,2
  )

  , view_web_component as (
    select dt, extension_id , count(distinct device_id) as unique_devices_web_component
    from dx_sandbox.daily_web_extension_viewer_funnel_helper_view
    where platform = 'web'
    and extension_anchor = 'component'
    and dt = (SELECT start_day FROM the_parameter_constants)
    group by 1,2
  )

  , view_web_video as (
    select dt, extension_id , count(distinct device_id) as unique_devices_web_video
    from dx_sandbox.daily_web_extension_viewer_funnel_helper_view
    where platform = 'web'
    and extension_anchor = 'video_overlay'
    and dt = (SELECT start_day FROM the_parameter_constants)
    group by 1,2
  )

  select
  w.dt,
  w.extension_id,
  'view' as action,
  unique_devices_web,
  unique_devices_web_video,
  unique_devices_web_component,
  unique_devices_web_panel
  from view_web w
  left join view_web_video v on w.dt = v.dt and w.extension_id = v.extension_id
  left join view_web_component c on w.dt = c.dt and w.extension_id = c.extension_id
  left join view_web_panel p on w.dt = p.dt and w.extension_id = p.extension_id

);

EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_view_log(-2);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_view_log(-2);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_view_log
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_view_log(-1);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_view_log(-1);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_view_log
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

DEALLOCATE the_delete_function_daily_web_extension_viewer_funnel_helper_view_log;
DEALLOCATE the_insert_function_daily_web_extension_viewer_funnel_helper_view_log;
