CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.dynamic_management_enables_and_disables);

PREPARE the_insert_function (BIGINT) AS
INSERT INTO the_temp_table(

  -- get the day to insert
  WITH
  the_parameter_constants AS (
    SELECT
    DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as start_day
  ),

  pre_cme as (
  select * from
  dx_csv.dynamic_management_beta_extensions
),
cme as (
  select a.*, g.name as game
  from pre_cme a
  join dx_metadata.all_extensions_latest b on a.extension_id = b.extension_id
  left join dbsnapshots.games g on g.id = a.game_id
),
enable_lazy as (
  select "time",
  case when channel_id is null then user_id else channel_id end as channel_id,
  extension_id,
  'dynamic_management_enable' as event,
  'lazy_migration' as reason,
  null as flag
  from spade.dynamic_management_enable
  where enable_reason = 'lazy_migration'
  and date = (select start_day from the_parameter_constants)
),
enable_recommendation_activate as (
  select "time",
  case when channel_id is null then user_id else channel_id end as channel_id,
  extension_id,
  'dynamic_management_enable' as event,
  'recommendation_activate' as reason,
  'recommendation' as flag
  from spade.extension_activate_button_click
  where location = 'dashboard_live'
  and date = (select start_day from the_parameter_constants)
),
enable_manual_activate as (
  select a."time",
  case when a.channel_id is null then a.user_id else a.channel_id end as channel_id,
  a.extension_id,
  'dynamic_management_enable' as event,
  'manual_activate' as reason,
  null as flag
  from spade.extension_activate a
  join spade.dynamic_management_enable b on abs(DATEDIFF(seconds, a."time",b."time")) <= 1 and a.channel_id = b.channel_id and a.extension_id=b.extension_id
  where
  a.extension_dynamic_managed is false
  and a.date =  (select start_day from the_parameter_constants)
  and b.date =  (select start_day from the_parameter_constants)
),
enable_permission_toggle as (
  select "time",
  user_id as channel_id,
  extension_id,
  'dynamic_management_enable' as event,
  'permission_toggle' as reason,
  null as flag
  from spade.dynamic_management_permission_toggle a
  where action = 'on'
  and date =  (select start_day from the_parameter_constants)
),
disable_manual_deactivate as (
  -- if manual deactivate event plus dm_disable or uninstall plus dm_disable
  select distinct a."time", a.channel_id, a.extension_id, 'dynamic_management_disable', 'manual_deactivate',  null as flag
  from spade.extension_deactivate a
  join cme on cme.extension_id = a.extension_id
  join spade.dynamic_management_disable b on abs(DATEDIFF(seconds, a."time",b."time")) <= 1 and a.channel_id = b.channel_id and a.extension_id=b.extension_id
  where a.date =  (select start_day from the_parameter_constants)
  and a.extension_dynamic_managed is false
  and b.date =  (select start_day from the_parameter_constants)

  union

  select distinct a."time", a.channel_id, a.extension_id, 'dynamic_management_disable', 'manual_deactivate',  null as flag
  from spade.extension_uninstall a
  join cme on cme.extension_id = a.extension_id
  join spade.dynamic_management_disable b on abs(DATEDIFF(seconds, a."time",b."time")) <= 1 and a.channel_id = b.channel_id and a.extension_id=b.extension_id
  where a.date =  (select start_day from the_parameter_constants)
  and b.date =  (select start_day from the_parameter_constants)

),
disable_permission_toggle as (
  select "time",
  user_id as channel_id,
  extension_id,
  'dynamic_management_disable' as event,
  'permission_toggle' as reason,
   null as flag
  from spade.dynamic_management_permission_toggle a
  where
  action = 'off'
  and date = (select start_day from the_parameter_constants)
),

-- when theres 2 permission toggle backend events and no activate or deactivate or front end permission toggle events
auto_toggle_off as (
  select distinct a."time", a.channel_id, a.extension_id, 'dynamic_management_disable', 'permission_toggle', 'auto' as flag
  from spade.dynamic_management_disable a
  left join spade.extension_activate c on c.extension_dynamic_managed is false and abs(DATEDIFF(seconds, a."time",c."time")) <= 1 and a.channel_id = c.channel_id and a.extension_id = c.extension_id
  left join spade.extension_deactivate d on d.extension_dynamic_managed is false and abs(DATEDIFF(seconds, a."time",d."time")) <= 1 and a.channel_id = d.channel_id and a.extension_id = d.extension_id
  left join spade.dynamic_management_permission_toggle e on abs(DATEDIFF(seconds, a."time",e."time")) <= 1 and a.channel_id = e.user_id and a.extension_id = e.extension_id
  where
  a.disable_reason = 'permissions_flags_set'
  and c.channel_id is NULL
  and d.channel_id is NULL
  and e.user_id is NULL
  and a.date =  (select start_day from the_parameter_constants)
),
final as (
  select * from enable_lazy
  union
  select * from enable_manual_activate
  union
  select * from enable_permission_toggle
  union
  select * from disable_manual_deactivate
  union
  select * from disable_permission_toggle
  union
  select * from auto_toggle_off
)

select "time", channel_id, a.extension_id, b.extension_name, cme.game_id, cme.game_flattened, event, reason, flag
from final a
join dx_metadata.all_extensions_latest b on a.extension_id = b.extension_id
join cme on cme.extension_id = a.extension_id
order by 2,1,3
);


PREPARE the_delete_function (BIGINT) AS
DELETE FROM dx_rollup.dynamic_management_enables_and_disables
WHERE date_trunc('day', dx_rollup.dynamic_management_enables_and_disables."time") = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')))
;
--RUN THE INSERT FUNCTIONS
EXECUTE the_delete_function (-7);
EXECUTE the_delete_function (-6);
EXECUTE the_delete_function (-5);
EXECUTE the_delete_function (-4);
EXECUTE the_delete_function (-3);
EXECUTE the_delete_function (-2);
EXECUTE the_delete_function (-1);

EXECUTE the_insert_function (-7);
EXECUTE the_insert_function (-6);
EXECUTE the_insert_function (-5);
EXECUTE the_insert_function (-4);
EXECUTE the_insert_function (-3);
EXECUTE the_insert_function (-2);
EXECUTE the_insert_function (-1);


-- Load TEMP_TABLE into TABLE AFTER DELETING THE DATA
INSERT INTO dx_rollup.dynamic_management_enables_and_disables
(SELECT * FROM the_temp_table);

-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;

