


-- CREATE TABLE dx_rollup.extension_daily_new_net_activations (
--     the_day                     TIMESTAMP WITHOUT TIME ZONE sortkey
--     , channel_id                   VARCHAR distkey
--     , extension_id                 VARCHAR
--     , metric_new_net_activations   INT
--
-- );


--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.extension_daily_new_net_activations);

PREPARE the_insert_function_extension_daily_new_net_activations (BIGINT) AS
INSERT INTO the_temp_table (

  WITH
  the_constants_timeframe AS (
    SELECT DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  ) as the_time_slot_mbr
  )

  , extension_daily_channel_presence_log AS (
      SELECT the_day, channel_id, extension_id
      FROM dx_rollup.extension_daily_channel_presence
      WHERE bool_extension_activated IS TRUE
      AND the_day>= (select the_time_slot_mbr::date -1 FROM the_constants_timeframe )
      AND the_day<(SELECT the_time_slot_mbr::date +1  FROM the_constants_timeframe)
      -- AND channel_id = '227436643'
    )

  , the_activate_logs_1 AS (
      SELECT *
      FROM extension_daily_channel_presence_log
      WHERE the_day=(SELECT the_time_slot_mbr::date -1 FROM the_constants_timeframe)
    )

    , the_activate_logs_2 AS (
      SELECT *
      FROM extension_daily_channel_presence_log
      WHERE the_day=(SELECT the_time_slot_mbr::date FROM the_constants_timeframe)
    )

    , full_join_logs AS (
      SELECT base1.the_day as prev_day, base2.the_day as today, NVL(base2.channel_id, base1.channel_id) as channel_id
      , base1.extension_id as extension_id_prev, base2.extension_id as extension_id_now, NVL(base1.extension_id, base2.extension_id) as extension_id
      FROM the_activate_logs_1 as base1
      full outer JOIN  the_activate_logs_2 as base2
      on base1.channel_id = base2.channel_id and base1.extension_id = base2.extension_id
    )

  , final_data AS (
      SELECT case when today is null then prev_day+1 else today end as the_day, channel_id, extension_id
      --given a full outer join of month(t-1) with month(t) and only for bool_extension_activated==TRUE
      , CASE

      -- IF extension_id = extension_id_prev THEN 0 for new net activations (was activated previous month and still activated this month)
      WHEN extension_id_now = extension_id_prev THEN 0

      -- IF extension_id==NULL AND extension_id_prev!=NULL THEN -1 for new net activations (was activated previous month and not activated this month anymore)
      WHEN extension_id_now IS NULL AND extension_id_prev IS NOT NULL THEN -1

      -- IF extension_id!=NULL AND extension_id_prev==NULL THEN -1 for new net activations (was activated previous month and not activated this month anymore)
      WHEN extension_id_now IS NOT NULL AND extension_id_prev IS NULL THEN 1

      -- -- IF month(time_most_recent_activate) > month(start_time) THEN 999 for new net activations [this should be an unexpected side effect error]
      -- WHEN month_most_recent_activate > start_time THEN 999

      ELSE 1000 --THIS SHOULDNT HAPPEN?
      END AS metric_new_net_activations
      FROM full_join_logs AS base
    )
  SELECT * FROM final_data

);

PREPARE the_delete_function_extension_daily_new_net_activations (BIGINT) AS
DELETE FROM dx_rollup.extension_daily_new_net_activations
WHERE dx_rollup.extension_daily_new_net_activations.the_day = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )
;

--RUN THE STUFF

EXECUTE the_insert_function_extension_daily_new_net_activations (-2);
EXECUTE the_delete_function_extension_daily_new_net_activations (-2);
INSERT INTO dx_rollup.extension_daily_new_net_activations (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function_extension_daily_new_net_activations (-1);
EXECUTE the_delete_function_extension_daily_new_net_activations (-1);
INSERT INTO dx_rollup.extension_daily_new_net_activations (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;






-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function_extension_daily_new_net_activations;
DEALLOCATE the_delete_function_extension_daily_new_net_activations;

