DROP TABLE IF EXISTS the_temp_table; -- just in case there's a duplicate named table called "the_temp_table" since we often reuse this name
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.extensions_metadata_helper_lifecycle_log);

INSERT INTO the_temp_table (



WITH

  delete_logs AS (
    SELECT
      "time"::TIMESTAMP, extension_id::VARCHAR, extension_version::VARCHAR, state::VARCHAR
    FROM spade.extension_delete
    WHERE extension_id IS NOT NULL AND extension_version IS NOT NULL
      AND state IN ('Deleted') --there is non 'Deleted' data in this table for op.gg league of legends extensions for date=2017-11-10
    GROUP BY 1,2,3,4
  )
  , lifecycle_logs AS (
    SELECT "time"::TIMESTAMP, extension_id::VARCHAR, extension_version::VARCHAR, state::VARCHAR
    FROM spade.extension_lifecycle
    WHERE state NOT IN ('Deleted') -- don't use deleted data here
    GROUP BY 1,2,3,4
  )
  , final_lifecycle AS (
    SELECT * FROM lifecycle_logs
    UNION ALL SELECT * FROM delete_logs
  )

  , the_latest_timestamp AS (
    SELECT extension_id, extension_version, MAX("time") AS the_max_time
    FROM final_lifecycle
    GROUP BY 1,2
  )

  , final_data AS (
    SELECT base.extension_id, base.extension_version, base.state AS extension_state, the_max_time AS "time"
    FROM final_lifecycle AS base
    RIGHT JOIN the_latest_timestamp AS t ON
      base.extension_id = t.extension_id
      AND base.extension_version = t.extension_version
      AND base."time" = t.the_max_time
  )

SELECT extension_id::VARCHAR(32), extension_version::VARCHAR(50), extension_state::VARCHAR(50), "time"::TIMESTAMP
FROM final_data
-- only select records that happened up to yesterday
WHERE "time"<DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))


);





DELETE FROM dx_sandbox.extensions_metadata_helper_lifecycle_log
;



INSERT INTO dx_sandbox.extensions_metadata_helper_lifecycle_log (
  SELECT * FROM the_temp_table
);
