

DROP TABLE IF EXISTS the_temp_table; -- just in case there's a duplicate named table called "the_temp_table" since we often reuse this name
CREATE TEMP TABLE the_temp_table (LIKE dx_metadata.extensions_metadata_history_extension_versions_all);

INSERT INTO the_temp_table (






WITH
--get extensions_metadata_helper_lifecycle_log
extensions_metadata_helper_lifecycle_log AS (
  SELECT extension_id, extension_version, extension_state_lower AS extension_state, "time"
  FROM dx_sandbox.extensions_metadata_helper_lifecycle_log AS ll
  LEFT JOIN dx_csv.extensions_state_mapping AS m ON ll.extension_state = m.extension_state_upper
)

-- join with dx_sandbox.extensions_metadata_helper_all_version_state since that is the data from most recent data from dynamodb
, extension_state_pass1 AS (
  SELECT
    base.the_day, base.extension_id, base.extension_version, base.extension_name, avs.extension_state
    , extension_category_id, extension_category_name, extension_author_name, extension_support_email, extension_url
    , is_bits_enabled, is_chat_enabled, is_overlay_enabled, is_component_enabled, is_panel_enabled
    , is_mobile_enabled, is_android_enabled, is_ios_enabled, is_viewer_identity_required, is_whitelisted_extension, whitelist_channels
  FROM dx_sandbox.extensions_metadata_helper_metadata_main AS base
  LEFT JOIN dx_sandbox.extensions_metadata_helper_all_version_state AS avs ON
    base.the_day = avs.the_day
    AND base.extension_id = avs.extension_id
    AND base.extension_version = avs.extension_version
  WHERE base.the_day = DATEADD('day', -1,  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )
)





-- join with dx_sandbox.extensions_metadata_helper_lifecycle_log as next pass since this is data from lifecycle logs and could have some errors?
, extension_state_pass2 AS (
  SELECT
    base.the_day, base.extension_id, base.extension_version, base.extension_name, NVL(base.extension_state, ll.extension_state) AS extension_state
    , extension_category_id, extension_category_name, extension_author_name, extension_support_email, extension_url
    , is_bits_enabled, is_chat_enabled, is_overlay_enabled, is_component_enabled, is_panel_enabled
    , is_mobile_enabled, is_android_enabled, is_ios_enabled, is_viewer_identity_required, is_whitelisted_extension, whitelist_channels
  FROM extension_state_pass1 AS base
  LEFT JOIN extensions_metadata_helper_lifecycle_log AS ll ON
    base.extension_id = ll.extension_id
    AND base.extension_version = ll.extension_version
)


SELECT * FROM extension_state_pass2






);




DELETE FROM dx_metadata.extensions_metadata_history_extension_versions_all
WHERE the_day = DATEADD('day', -1,  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )
;



INSERT INTO dx_metadata.extensions_metadata_history_extension_versions_all (
  SELECT * FROM the_temp_table
);

