-- return twitch user_id and the type of extension action completed

WITH
action_start_extension AS (
SELECT MIN(time) AS "time", user_id, 'start_extension_onboarding' AS action
FROM logs.cobalt_button_click
WHERE url LIKE '%dev.twitch.tv%'
AND label='Start TIMS Onboarding Proces'
AND time>='2017-08-01 00:00:00'
GROUP BY user_id
)

, action_register_extension AS (
SELECT MIN(time) AS "time", user_id, 'register_extension' AS action
FROM logs.cobalt_button_click
WHERE url LIKE '%dev.twitch.tv%'
AND label='Register Extension'
AND time>='2017-08-01 00:00:00'
GROUP BY user_id
)

SELECT * FROM action_start_extension
UNION ALL SELECT * FROM action_register_extension
ORDER BY user_id, "time"
