-- SPEC: dx_sandbox.edcp_helper_all_install_records_parsed_final
-- channel_id
-- , extension_id
-- , bool_extension_installed
--
-- SPEC: dx_sandbox.edcp_helper_all_activate_records_parsed
-- channel_id
-- , extension_id
-- , extension_anchor
-- , extension_slot


-- CREATE TABLE IF NOT EXISTS dx_rollup.extension_daily_channel_presence_new (
--     the_day                     DATE distkey
--     , channel_id                BIGINT sortkey
--     , extension_id              VARCHAR(32)
--     , extension_anchor          VARCHAR(50)
--     , extension_slot            VARCHAR(50)
--     , bool_extension_installed  BOOLEAN
--     , bool_extension_activated  BOOLEAN
-- )


DROP TABLE IF EXISTS the_temp_table; -- just in case there's a duplicate named table called "the_temp_table" since we often reuse this name
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.extension_daily_channel_presence_new );

INSERT INTO the_temp_table (


  SELECT
    DATEADD('day', -1,  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )::DATE AS the_day
    , install.channel_id
    , install.extension_id
    , extension_anchor
    , extension_slot
    , bool_extension_installed
    , CASE WHEN activate.extension_id IS NOT NULL THEN TRUE ELSE FALSE END AS bool_extension_activated
  FROM dx_sandbox.edcp_helper_all_install_records_parsed_final AS install
  LEFT JOIN dx_sandbox.edcp_helper_all_activate_records_parsed_final AS activate ON
    install.extension_id = activate.extension_id
    AND install.channel_id = activate.channel_id



);




DELETE FROM dx_rollup.extension_daily_channel_presence_new
WHERE the_day = DATEADD('day', -1,  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )
;



INSERT INTO dx_rollup.extension_daily_channel_presence_new (
  SELECT * FROM the_temp_table
);


DELETE FROM dx_sandbox.edcp_helper_all_activate_records_parsed_final;
DELETE FROM dx_sandbox.edcp_helper_all_install_records_parsed_part1;
DELETE FROM dx_sandbox.edcp_helper_all_install_records_parsed_part2;
DELETE FROM dx_sandbox.edcp_helper_all_install_records_parsed_part3;
DELETE FROM dx_sandbox.edcp_helper_all_install_records_parsed_final;
