
DROP TABLE IF EXISTS dx_sandbox.edcp_helper_all_install_records_parsed;

CREATE TABLE dx_sandbox.edcp_helper_all_install_records_parsed AS




WITH

the_logs AS (
  SELECT id::BIGINT AS channel_id, installs AS installs_json, slots AS activate_json
  FROM dbsnapshots.extensions_channel_extensions
)

, extension_life_cycle_compress AS (
  SELECT extension_id, TRUE AS flag_is_deleted
  FROM dx_sandbox.extensions_metadata_helper_lifecycle_log
  WHERE extension_state IN ('Deleted')
  GROUP BY 1
)

-- previous versions of OP.gg league of legends extension was deleted, but it is still a "released" extension
-- https://www.twitch.tv/ext/lgpf9j7y8n1ja9onkb6w7bxfkhk2zl
, deleted_extensions_list AS (
  SELECT * FROM extension_life_cycle_compress
  WHERE extension_id NOT IN (SELECT extension_id FROM dx_metadata.released_extensions_latest)
)

, install_extensions_logs AS (
  SELECT
    channel_id
    , RTRIM(REGEXP_SUBSTR(installs_json, '[0-9a-z.]+!', 1, num.n), '!') as extension_id --- UPDATE REGEX STRING MANUALLY HERE CANNOT USE CTE ---
  FROM the_logs, dx_metadata.number_series AS num
  WHERE num.n >= 1 AND num.n <= REGEXP_COUNT(installs_json, '[0-9a-z.]+!')  --- UPDATE REGEX STRING MANUALLY HERE CANNOT USE CTE ---
)

, install_extensions_list AS (
  SELECT a.*, TRUE AS bool_extension_installed
  FROM install_extensions_logs AS a
  LEFT JOIN deleted_extensions_list AS b ON a.extension_id = b.extension_id
  WHERE flag_is_deleted IS NULL OR flag_is_deleted = FALSE
)


SELECT * FROM install_extensions_list;
