
DROP TABLE IF EXISTS dx_sandbox.edcp_helper_all_install_records_parsed_part1;

CREATE TABLE dx_sandbox.edcp_helper_all_install_records_parsed_part1 AS

WITH

the_logs AS (
  SELECT id::BIGINT AS channel_id, installs AS installs_json
  FROM dbsnapshots.extensions_channel_extensions
  WHERE
    installs IS NOT NULL
    AND id IS NOT NULL
    AND f_is_numeric(id) = TRUE
)

, extension_life_cycle_compress AS (
  SELECT extension_id, TRUE AS flag_is_deleted
  FROM dx_sandbox.extensions_metadata_helper_lifecycle_log
  WHERE extension_state IN ('Deleted')
  GROUP BY 1
)

-- previous versions of OP.gg league of legends extension was deleted, but it is still a "released" extension
-- https://www.twitch.tv/ext/lgpf9j7y8n1ja9onkb6w7bxfkhk2zl
, deleted_extensions_list AS (
  SELECT * FROM extension_life_cycle_compress
  WHERE extension_id NOT IN (SELECT extension_id FROM dx_metadata.released_extensions_latest)
)

--used to get the maximum number of install records for all channels
, install_per_channel AS (
  SELECT channel_id, REGEXP_COUNT(installs_json, '[0-9a-z.]+!')::BIGINT AS install_record  --- UPDATE REGEX STRING MANUALLY HERE CANNOT USE CTE ---
  FROM the_logs
)

, smaller_number_series AS (
  SELECT n
  FROM dx_metadata.number_series
  WHERE n>=1 AND n<=(SELECT MAX(install_record) FROM install_per_channel)
)

, cross_join_logs_number_series AS (
  SELECT channel_id, installs_json, n
  FROM the_logs
  CROSS JOIN smaller_number_series
)

SELECT * FROM cross_join_logs_number_series;
