-- QA the table dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1


SELECT random_group, COUNT(DISTINCT viewer_id) AS viewers, COUNT(1) AS rows, COUNT(DISTINCT start_date) AS weeks
FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1
GROUP BY 1
ORDER BY 1
;


-- error found:
-- a given viewer_id has multiple random_group assigned to them, although the lifecycle_stage data is consistent for the same week
--
SELECT *
FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1
WHERE viewer_id IN (154605684,264507583)
ORDER BY viewer_id, year, week_number
;


-- NO ISSUES HERE WITH A GIVEN viewer_id HAVING MULTIPLE lifecycle_stage IN THE SAME WEEK! YAY!!
WITH
lifecycle_error_ids AS (
  SELECT viewer_id
  FROM (
    SELECT year, week_number, viewer_id, COUNT(DISTINCT lifecycle_stage) AS lifecycle_stages, COUNT(1) AS rows
    FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1
    GROUP BY 1,2,3
  )
  WHERE lifecycle_stages>1
  GROUP BY 1
)

SELECT *
FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1
WHERE viewer_id IN (SELECT viewer_id FROM lifecycle_error_ids)
ORDER BY viewer_id, year, week_number
;



-- some viewer_id have multiple device_id in the_device_id_array (ie this is the correct way)
WITH
array_length AS (
  SELECT viewer_id
  FROM (
    SELECT year, week_number, viewer_id, random_group, json_array_length(the_device_id_array) AS device_id_array_length
    FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1
    GROUP BY 1,2,3,4,5
  )
  WHERE device_id_array_length>1
  GROUP BY 1
)

SELECT *
FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1
WHERE viewer_id IN (SELECT viewer_id FROM array_length)
ORDER BY viewer_id, year, week_number
;



-- get the max length for the_device_id_array, used in __02.sql logic later
-- the answer is 2
SELECT MAX(device_id_array_length)
FROM (
SELECT year, week_number, viewer_id, random_group, json_array_length(the_device_id_array) AS device_id_array_length
FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1
GROUP BY 1,2,3,4,5
)
;
