--https://stackoverflow.com/questions/22548928/how-to-change-table-schema-after-created-in-redshift


SELECT COUNT(1) FROM dx_rollup.creator_stream_session;

DROP TABLE IF EXISTS dx_sandbox.creator_stream_session_airflow_archive;
CREATE TABLE dx_sandbox.creator_stream_session_airflow_archive (like dx_rollup.creator_stream_session);
ALTER TABLE dx_sandbox.creator_stream_session_airflow_archive APPEND FROM dx_rollup.creator_stream_session;
--INSERT INTO dx_sandbox.channel_daily_status_airflow_archive (SELECT * FROM dx_rollup.channel_daily_status);

SELECT COUNT(1) FROM dx_sandbox.creator_stream_session_airflow_archive;





--
--
-- --DATA QA
-- SELECT COUNT(1) FROM dx_sandbox.channel_daily_status_airflow_archive WHERE the_date>='2019-01-01';
--
-- SELECT MIN(the_date), MAX(the_date) FROM dx_sandbox.channel_daily_status_airflow_archive;
--
--
-- SELECT COUNT(1) FROM dx_rollup.channel_daily_status WHERE the_date>='2019-01-01';
-- SELECT COUNT(1) FROM dx_rollup.channel_daily_status;



--THEN DROP TABLE
DROP TABLE dx_rollup.creator_stream_session;


--THEN CREATE THE "NEW VIEW" dx_rollup.channel_daily_status that references cubes.channel_daily_status

create view dx_rollup.creator_stream_session as select * from cubes.creator_stream_sessions
with no schema binding;


drop view dx_rollup.creator_stream_session cascade;






--Advanced QA
WITH
cubes_data AS (
  SELECT date AS the_date, COUNT(1) AS count1_cubes, COUNT(DISTINCT channel_id) AS distinct_channels_cubes
  FROM cubes.creator_stream_sessions
  GROUP BY 1
)
, sandbox_data AS (
  SELECT the_day AS the_date, COUNT(1) AS count1_sandbox, COUNT(DISTINCT channel_id) AS distinct_channels_sandbox
  FROM dx_sandbox.creator_stream_session_airflow_archive
  GROUP BY 1
)
, the_join AS (
  SELECT sandbox_data.the_date, count1_cubes, count1_sandbox, distinct_channels_cubes, distinct_channels_sandbox
  FROM sandbox_data
  INNER JOIN cubes_data ON sandbox_data.the_date = cubes_data.the_date
)

SELECT * FROM the_join WHERE count1_cubes<>count1_sandbox OR distinct_channels_cubes<>distinct_channels_sandbox ORDER BY the_date;
