-- how many developers are live + actively integrated with us today?
-- count both game integrations and
-- client IDs with live API applications that have more than 1k lifetime oauths
-- game integrations = drops


-- Get list of drops IDs and their last drops activity (vhs_link)



WITH
the_list AS (
SELECT service, REPLACE(game, ',', '') AS game FROM ( SELECT service, lower(game) as game FROM logs.vhs_report GROUP BY 1,2)
)


, the_records AS (
SELECT service, MIN(time) AS first_drops, MAX(time) AS last_drops, COUNT(DISTINCT user_id) AS users, COUNT(1) AS rows
FROM logs.vhs_link
GROUP BY 1
)

SELECT the_list.*, the_records.*
FROM the_list
LEFT JOIN the_records ON the_list.service = the_records.service
