--https://stackoverflow.com/questions/22548928/how-to-change-table-schema-after-created-in-redshift

DROP TABLE dx_sandbox.channel_daily_status_airflow_archive;
CREATE TABLE dx_sandbox.channel_daily_status_airflow_archive (like dx_rollup.channel_daily_status);
ALTER TABLE dx_sandbox.channel_daily_status_airflow_archive APPEND FROM dx_rollup.channel_daily_status;
--INSERT INTO dx_sandbox.channel_daily_status_airflow_archive (SELECT * FROM dx_rollup.channel_daily_status);




--DATA QA
SELECT COUNT(1) FROM dx_sandbox.channel_daily_status_airflow_archive WHERE the_date>='2019-01-01';

SELECT MIN(the_date), MAX(the_date) FROM dx_sandbox.channel_daily_status_airflow_archive;


SELECT COUNT(1) FROM dx_rollup.channel_daily_status WHERE the_date>='2019-01-01';
SELECT COUNT(1) FROM dx_rollup.channel_daily_status;



--THEN DROP TABLE
DROP TABLE dx_rollup.channel_daily_status;


--THEN CREATE THE "NEW VIEW" dx_rollup.channel_daily_status that references cubes.channel_daily_status

create view dx_rollup.channel_daily_status as select * from cubes.channel_daily_status
with no schema binding;









--Advanced QA
WITH
cubes_data AS (
  SELECT the_date, COUNT(1) AS count1_cubes, COUNT(DISTINCT channel_id) AS distinct_channels_cubes
  FROM cubes.channel_daily_status
  GROUP BY 1
)
, sandbox_data AS (
  SELECT the_date, COUNT(1) AS count1_sandbox, COUNT(DISTINCT channel_id) AS distinct_channels_sandbox
  FROM dx_sandbox.channel_daily_status_airflow_archive
  GROUP BY 1
)
, the_join AS (
  SELECT sandbox_data.the_date, count1_cubes, count1_sandbox, distinct_channels_cubes, distinct_channels_sandbox
  FROM sandbox_data
  LEFT JOIN cubes_data ON sandbox_data.the_date = cubes_data.the_date
)

SELECT * FROM the_join WHERE count1_cubes<>count1_sandbox OR distinct_channels_cubes<>distinct_channels_sandbox ORDER BY the_date;
