--NOTE: spec for dx_rollup.active_viewer_of_game
-- the_day
-- platform
-- channel_id
-- game
-- game_flattened
-- user_id
-- device_id


-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_active_viewer_of_game (BIGINT) AS
DELETE FROM dx_rollup.active_viewer_of_game
WHERE the_day = DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  )
;


--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.active_viewer_of_game);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_active_viewer_of_game (BIGINT) AS
INSERT INTO the_temp_table (

  WITH
  the_constants_date AS (
    SELECT DATEADD('day', $1, the_index_date) AS the_day
    FROM the_dates_table
  )
  , fmp_logs AS (
    SELECT date, "time", device_id, user_id, channel_id, game, platform
    FROM cubes.five_minute_plays
    WHERE date = (SELECT the_day FROM the_constants_date)
  )
  , final_data AS (
    SELECT date AS the_day, platform, channel_id, game, f_game_flattened(game) AS game_flattened, user_id, device_id
    FROM fmp_logs
    GROUP BY 1,2,3,4,5,6,7
  )


  SELECT * FROM final_data

);


EXECUTE the_insert_function_active_viewer_of_game (-1); EXECUTE the_delete_function_active_viewer_of_game (-1);   INSERT INTO dx_rollup.active_viewer_of_game    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_active_viewer_of_game (-2); EXECUTE the_delete_function_active_viewer_of_game (-2);   INSERT INTO dx_rollup.active_viewer_of_game    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
