--NOTE: SPEC FOR ---> dx_rollup.active_streamer_of_game
-- the_day
-- rolling_7_day_start
-- rolling_7_day_end
-- game
-- game_flattened
-- channel_id
-- mb_of_game_rolling_7_day
-- is_active_streamer_of_game


--NOTE: an "active streamer of a game" is true when you have streamed at least 30 minutes of the game in the recent 7 day period
--This is a definition we defined along with Adam Butterfoss (PM) as part of the League of Legends extension launch








-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_active_streamer_of_game (BIGINT) AS
DELETE FROM dx_rollup.active_streamer_of_game
WHERE the_day = DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  )
;


--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.active_streamer_of_game);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_active_streamer_of_game (BIGINT) AS
INSERT INTO the_temp_table (


  WITH

  the_constants_date AS (
    SELECT DATEADD('day', $1, the_index_date) AS the_day
      , DATEADD('day', $1-6, the_index_date) AS rolling_7_day_start
      , DATEADD('day', $1, the_index_date) AS rolling_7_day_end
    FROM (SELECT the_index_date FROM the_dates_table)
  )

  , the_constants_other AS (
    SELECT 'live'::VARCHAR(10) AS the_live_string
      , 0::BIGINT AS invalid_channel_category_id --at the start of stream this shows null data for some fields so ignoring
      , 30::BIGINT AS is_active_streamer_of_game_cutoff -- stream at least 30 mins
  )

  , liveline_logs AS (
    SELECT date, DATE_TRUNC('minute', "time") AS "time", channel_id, channel_category_id, channel_category_name AS game, f_game_flattened(channel_category_name) AS game_flattened--, channel_title
    FROM spade.liveline_channel
    WHERE
      date>=(SELECT rolling_7_day_start FROM the_constants_date) AND date<=(SELECT rolling_7_day_end FROM the_constants_date)
      AND channel_category_id<>(SELECT invalid_channel_category_id FROM the_constants_other) --at the start of stream this shows null data for some fields so ignoring
      AND stream_type = (SELECT the_live_string FROM the_constants_other)
      AND date IS NOT NULL
      AND "time" IS NOT NULL
      AND channel_id IS NOT NULL
      AND channel_category_id IS NOT NULL
      AND channel_category_name IS NOT NULL
    GROUP BY 1,2,3,4,5,6
  )

  , agg_data AS (
    SELECT game, game_flattened, channel_id, SUM(1) AS mb_of_game_rolling_7_day
    FROM liveline_logs
    GROUP BY 1,2,3
  )

  , final_data AS (
    SELECT
      (SELECT the_day FROM the_constants_date) AS the_day
      , (SELECT rolling_7_day_start FROM the_constants_date) AS rolling_7_day_start
      , (SELECT rolling_7_day_end FROM the_constants_date) AS rolling_7_day_end
      , game, game_flattened, channel_id, mb_of_game_rolling_7_day
      , CASE WHEN mb_of_game_rolling_7_day>=(SELECT is_active_streamer_of_game_cutoff FROM the_constants_other) THEN TRUE ELSE FALSE END AS is_active_streamer_of_game
    FROM agg_data
  )

  SELECT * FROM final_data


);





EXECUTE the_insert_function_active_streamer_of_game (-1); EXECUTE the_delete_function_active_streamer_of_game (-1);   INSERT INTO dx_rollup.active_streamer_of_game    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_active_streamer_of_game (-2); EXECUTE the_delete_function_active_streamer_of_game (-2);   INSERT INTO dx_rollup.active_streamer_of_game    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
