-- by yanghung
-- generate log of data of when a specific user_id oauth'ed with streamlabs or muxy
DROP TABLE IF EXISTS    analysis.panalysis879_oauth_streamlabs_muxy;
CREATE TABLE    analysis.panalysis879_oauth_streamlabs_muxy    AS

WITH
oauth_log AS (
  -- There are cases where we have multiple records of the person conducting the oauth, hence the min_time and max_time
  SELECT oa.user_id, oa.client_id, cl.app_name, MIN(oa.time) AS min_time, MAX(oa.time) AS max_time
  FROM logs.oauth_authorize AS oa
  RIGHT JOIN analysis.panalysis879_oauth_client_list AS cl ON oa.client_id=cl.client_id -- only take those client_id records that are in the client_list
  GROUP BY oa.user_id, oa.client_id, cl.app_name
)



SELECT user_id
, MIN(CASE WHEN app_name='streamlabs' THEN min_time ELSE NULL END) AS streamlabs_min_time
, MAX(CASE WHEN app_name='streamlabs' THEN max_time ELSE NULL END) AS streamlabs_max_time
, MIN(CASE WHEN app_name='muxy' THEN min_time ELSE NULL END) AS muxy_min_time
, MAX(CASE WHEN app_name='muxy' THEN max_time ELSE NULL END) AS muxy_max_time
, MIN(min_time) AS abs_min_time
, MAX(max_time) AS abs_max_time
FROM oauth_log
GROUP BY user_id
;
