-- by yanghung
-- generate broadcaster tier stats lookup table, the tier is based off of avg ccu over time frame we have muxy and streamlabs data
DROP TABLE IF EXISTS    analysis.panalysis879_broadcaster_tier_list;
CREATE TABLE    analysis.panalysis879_broadcaster_tier_list    AS


WITH
broadcaster_stats AS (
SELECT channel_id, SUM(total) as mw, SUM(1) as mb, AVG(total::float) as avg_ccu
FROM logs.channel_concurrents
WHERE time>='2016-08-01' AND time<'2017-07-01' -- take time frame of overall time range to get their tier
GROUP BY channel_id
)

SELECT *,
CASE
  WHEN avg_ccu<2 THEN 'T0: 0-2 CCU'
  WHEN avg_ccu<25 THEN 'T1: 2-25 CCU'
  WHEN avg_ccu<200 THEN 'T2: 25-200 CCU'
  WHEN avg_ccu<2000 THEN 'T3: 200-2000 CCU'
  WHEN avg_ccu>=2000 THEN 'T4: 2000+ CCU'
END AS tier
FROM broadcaster_stats
