-- by yanghung
-- create final modeling data for DID analysis


-- DROP TABLE IF EXISTS    analysis.panalysis879_did_dataset;
-- CREATE TABLE    analysis.panalysis879_did_dataset    AS

WITH
control_data AS (
  SELECT day, the_group_new, tier, COUNT(DISTINCT channel_id) AS num_channels
  , AVG(channel_rev_total_week_minus_1) AS avg_channel_rev_total_week_minus_1
  , AVG(channel_rev_total_week_minus_2) AS avg_channel_rev_total_week_minus_2
  , AVG(channel_rev_total_week_minus_3) AS avg_channel_rev_total_week_minus_3
  , AVG(channel_rev_total_week_minus_4) AS avg_channel_rev_total_week_minus_4
  , AVG(channel_rev_total_week_minus_5) AS avg_channel_rev_total_week_minus_5
  , AVG(channel_rev_total_week_minus_6) AS avg_channel_rev_total_week_minus_6
  , AVG(channel_rev_total_week_minus_7) AS avg_channel_rev_total_week_minus_7
  , AVG(channel_rev_total_week_minus_8) AS avg_channel_rev_total_week_minus_8
  , AVG(mins_watched_week_minus_1) AS avg_mins_watched_week_minus_1
  , AVG(mins_watched_week_minus_2) AS avg_mins_watched_week_minus_2
  , AVG(mins_watched_week_minus_3) AS avg_mins_watched_week_minus_3
  , AVG(mins_watched_week_minus_4) AS avg_mins_watched_week_minus_4
  , AVG(mins_watched_week_minus_5) AS avg_mins_watched_week_minus_5
  , AVG(mins_watched_week_minus_6) AS avg_mins_watched_week_minus_6
  , AVG(mins_watched_week_minus_7) AS avg_mins_watched_week_minus_7
  , AVG(mins_watched_week_minus_8) AS avg_mins_watched_week_minus_8
  , AVG(mins_broadcast_week_minus_1) AS avg_mins_broadcast_week_minus_1
  , AVG(mins_broadcast_week_minus_2) AS avg_mins_broadcast_week_minus_2
  , AVG(mins_broadcast_week_minus_3) AS avg_mins_broadcast_week_minus_3
  , AVG(mins_broadcast_week_minus_4) AS avg_mins_broadcast_week_minus_4
  , AVG(mins_broadcast_week_minus_5) AS avg_mins_broadcast_week_minus_5
  , AVG(mins_broadcast_week_minus_6) AS avg_mins_broadcast_week_minus_6
  , AVG(mins_broadcast_week_minus_7) AS avg_mins_broadcast_week_minus_7
  , AVG(mins_broadcast_week_minus_8) AS avg_mins_broadcast_week_minus_8
  , AVG(channel_rev_total_week_plus_1) AS avg_channel_rev_total_week_plus_1
  , AVG(channel_rev_total_week_plus_2) AS avg_channel_rev_total_week_plus_2
  , AVG(channel_rev_total_week_plus_3) AS avg_channel_rev_total_week_plus_3
  , AVG(channel_rev_total_week_plus_4) AS avg_channel_rev_total_week_plus_4
  , AVG(channel_rev_total_week_plus_5) AS avg_channel_rev_total_week_plus_5
  , AVG(channel_rev_total_week_plus_6) AS avg_channel_rev_total_week_plus_6
  , AVG(channel_rev_total_week_plus_7) AS avg_channel_rev_total_week_plus_7
  , AVG(channel_rev_total_week_plus_8) AS avg_channel_rev_total_week_plus_8
  , AVG(mins_watched_week_plus_1) AS avg_mins_watched_week_plus_1
  , AVG(mins_watched_week_plus_2) AS avg_mins_watched_week_plus_2
  , AVG(mins_watched_week_plus_3) AS avg_mins_watched_week_plus_3
  , AVG(mins_watched_week_plus_4) AS avg_mins_watched_week_plus_4
  , AVG(mins_watched_week_plus_5) AS avg_mins_watched_week_plus_5
  , AVG(mins_watched_week_plus_6) AS avg_mins_watched_week_plus_6
  , AVG(mins_watched_week_plus_7) AS avg_mins_watched_week_plus_7
  , AVG(mins_watched_week_plus_8) AS avg_mins_watched_week_plus_8
  , AVG(mins_broadcast_week_plus_1) AS avg_mins_broadcast_week_plus_1
  , AVG(mins_broadcast_week_plus_2) AS avg_mins_broadcast_week_plus_2
  , AVG(mins_broadcast_week_plus_3) AS avg_mins_broadcast_week_plus_3
  , AVG(mins_broadcast_week_plus_4) AS avg_mins_broadcast_week_plus_4
  , AVG(mins_broadcast_week_plus_5) AS avg_mins_broadcast_week_plus_5
  , AVG(mins_broadcast_week_plus_6) AS avg_mins_broadcast_week_plus_6
  , AVG(mins_broadcast_week_plus_7) AS avg_mins_broadcast_week_plus_7
  , AVG(mins_broadcast_week_plus_8) AS avg_mins_broadcast_week_plus_8
  FROM analysis.panalysis879_eligible_broadcaster_weekly_lookup
  WHERE the_group_new='control'
  GROUP BY day, the_group_new, tier
)
, test_data AS (
  SELECT install_app_day, the_group_new, tier, COUNT(DISTINCT channel_id) AS num_channels
  , AVG(channel_rev_total_week_minus_1) AS avg_channel_rev_total_week_minus_1
  , AVG(channel_rev_total_week_minus_2) AS avg_channel_rev_total_week_minus_2
  , AVG(channel_rev_total_week_minus_3) AS avg_channel_rev_total_week_minus_3
  , AVG(channel_rev_total_week_minus_4) AS avg_channel_rev_total_week_minus_4
  , AVG(channel_rev_total_week_minus_5) AS avg_channel_rev_total_week_minus_5
  , AVG(channel_rev_total_week_minus_6) AS avg_channel_rev_total_week_minus_6
  , AVG(channel_rev_total_week_minus_7) AS avg_channel_rev_total_week_minus_7
  , AVG(channel_rev_total_week_minus_8) AS avg_channel_rev_total_week_minus_8
  , AVG(mins_watched_week_minus_1) AS avg_mins_watched_week_minus_1
  , AVG(mins_watched_week_minus_2) AS avg_mins_watched_week_minus_2
  , AVG(mins_watched_week_minus_3) AS avg_mins_watched_week_minus_3
  , AVG(mins_watched_week_minus_4) AS avg_mins_watched_week_minus_4
  , AVG(mins_watched_week_minus_5) AS avg_mins_watched_week_minus_5
  , AVG(mins_watched_week_minus_6) AS avg_mins_watched_week_minus_6
  , AVG(mins_watched_week_minus_7) AS avg_mins_watched_week_minus_7
  , AVG(mins_watched_week_minus_8) AS avg_mins_watched_week_minus_8
  , AVG(mins_broadcast_week_minus_1) AS avg_mins_broadcast_week_minus_1
  , AVG(mins_broadcast_week_minus_2) AS avg_mins_broadcast_week_minus_2
  , AVG(mins_broadcast_week_minus_3) AS avg_mins_broadcast_week_minus_3
  , AVG(mins_broadcast_week_minus_4) AS avg_mins_broadcast_week_minus_4
  , AVG(mins_broadcast_week_minus_5) AS avg_mins_broadcast_week_minus_5
  , AVG(mins_broadcast_week_minus_6) AS avg_mins_broadcast_week_minus_6
  , AVG(mins_broadcast_week_minus_7) AS avg_mins_broadcast_week_minus_7
  , AVG(mins_broadcast_week_minus_8) AS avg_mins_broadcast_week_minus_8
  , AVG(channel_rev_total_week_plus_1) AS avg_channel_rev_total_week_plus_1
  , AVG(channel_rev_total_week_plus_2) AS avg_channel_rev_total_week_plus_2
  , AVG(channel_rev_total_week_plus_3) AS avg_channel_rev_total_week_plus_3
  , AVG(channel_rev_total_week_plus_4) AS avg_channel_rev_total_week_plus_4
  , AVG(channel_rev_total_week_plus_5) AS avg_channel_rev_total_week_plus_5
  , AVG(channel_rev_total_week_plus_6) AS avg_channel_rev_total_week_plus_6
  , AVG(channel_rev_total_week_plus_7) AS avg_channel_rev_total_week_plus_7
  , AVG(channel_rev_total_week_plus_8) AS avg_channel_rev_total_week_plus_8
  , AVG(mins_watched_week_plus_1) AS avg_mins_watched_week_plus_1
  , AVG(mins_watched_week_plus_2) AS avg_mins_watched_week_plus_2
  , AVG(mins_watched_week_plus_3) AS avg_mins_watched_week_plus_3
  , AVG(mins_watched_week_plus_4) AS avg_mins_watched_week_plus_4
  , AVG(mins_watched_week_plus_5) AS avg_mins_watched_week_plus_5
  , AVG(mins_watched_week_plus_6) AS avg_mins_watched_week_plus_6
  , AVG(mins_watched_week_plus_7) AS avg_mins_watched_week_plus_7
  , AVG(mins_watched_week_plus_8) AS avg_mins_watched_week_plus_8
  , AVG(mins_broadcast_week_plus_1) AS avg_mins_broadcast_week_plus_1
  , AVG(mins_broadcast_week_plus_2) AS avg_mins_broadcast_week_plus_2
  , AVG(mins_broadcast_week_plus_3) AS avg_mins_broadcast_week_plus_3
  , AVG(mins_broadcast_week_plus_4) AS avg_mins_broadcast_week_plus_4
  , AVG(mins_broadcast_week_plus_5) AS avg_mins_broadcast_week_plus_5
  , AVG(mins_broadcast_week_plus_6) AS avg_mins_broadcast_week_plus_6
  , AVG(mins_broadcast_week_plus_7) AS avg_mins_broadcast_week_plus_7
  , AVG(mins_broadcast_week_plus_8) AS avg_mins_broadcast_week_plus_8
  FROM analysis.panalysis879_eligible_broadcaster_weekly_lookup
  WHERE the_group_new='test' AND day=install_app_day
  GROUP BY install_app_day, the_group_new, tier
)

, test_join_control AS (
SELECT td.install_app_day, td.tier, td.num_channels AS test_num_channels, cd.num_channels AS control_num_channels

, td.avg_channel_rev_total_week_minus_8 AS test_rev_total_week_minus_8
, td.avg_channel_rev_total_week_minus_7 AS test_rev_total_week_minus_7
, td.avg_channel_rev_total_week_minus_6 AS test_rev_total_week_minus_6
, td.avg_channel_rev_total_week_minus_5 AS test_rev_total_week_minus_5
, td.avg_channel_rev_total_week_minus_4 AS test_rev_total_week_minus_4
, td.avg_channel_rev_total_week_minus_3 AS test_rev_total_week_minus_3
, td.avg_channel_rev_total_week_minus_2 AS test_rev_total_week_minus_2
, td.avg_channel_rev_total_week_minus_1 AS test_rev_total_week_minus_1
, td.avg_channel_rev_total_week_plus_1 AS test_rev_total_week_plus_1
, td.avg_channel_rev_total_week_plus_2 AS test_rev_total_week_plus_2
, td.avg_channel_rev_total_week_plus_3 AS test_rev_total_week_plus_3
, td.avg_channel_rev_total_week_plus_4 AS test_rev_total_week_plus_4
, td.avg_channel_rev_total_week_plus_5 AS test_rev_total_week_plus_5
, td.avg_channel_rev_total_week_plus_6 AS test_rev_total_week_plus_6
, td.avg_channel_rev_total_week_plus_7 AS test_rev_total_week_plus_7
, td.avg_channel_rev_total_week_plus_8 AS test_rev_total_week_plus_8

, td.avg_mins_watched_week_minus_8 AS test_mins_watched_week_minus_8
, td.avg_mins_watched_week_minus_7 AS test_mins_watched_week_minus_7
, td.avg_mins_watched_week_minus_6 AS test_mins_watched_week_minus_6
, td.avg_mins_watched_week_minus_5 AS test_mins_watched_week_minus_5
, td.avg_mins_watched_week_minus_4 AS test_mins_watched_week_minus_4
, td.avg_mins_watched_week_minus_3 AS test_mins_watched_week_minus_3
, td.avg_mins_watched_week_minus_2 AS test_mins_watched_week_minus_2
, td.avg_mins_watched_week_minus_1 AS test_mins_watched_week_minus_1
, td.avg_mins_watched_week_plus_1 AS test_mins_watched_week_plus_1
, td.avg_mins_watched_week_plus_2 AS test_mins_watched_week_plus_2
, td.avg_mins_watched_week_plus_3 AS test_mins_watched_week_plus_3
, td.avg_mins_watched_week_plus_4 AS test_mins_watched_week_plus_4
, td.avg_mins_watched_week_plus_5 AS test_mins_watched_week_plus_5
, td.avg_mins_watched_week_plus_6 AS test_mins_watched_week_plus_6
, td.avg_mins_watched_week_plus_7 AS test_mins_watched_week_plus_7
, td.avg_mins_watched_week_plus_8 AS test_mins_watched_week_plus_8

, td.avg_mins_broadcast_week_minus_8 AS test_mins_broadcast_week_minus_8
, td.avg_mins_broadcast_week_minus_7 AS test_mins_broadcast_week_minus_7
, td.avg_mins_broadcast_week_minus_6 AS test_mins_broadcast_week_minus_6
, td.avg_mins_broadcast_week_minus_5 AS test_mins_broadcast_week_minus_5
, td.avg_mins_broadcast_week_minus_4 AS test_mins_broadcast_week_minus_4
, td.avg_mins_broadcast_week_minus_3 AS test_mins_broadcast_week_minus_3
, td.avg_mins_broadcast_week_minus_2 AS test_mins_broadcast_week_minus_2
, td.avg_mins_broadcast_week_minus_1 AS test_mins_broadcast_week_minus_1
, td.avg_mins_broadcast_week_plus_1 AS test_mins_broadcast_week_plus_1
, td.avg_mins_broadcast_week_plus_2 AS test_mins_broadcast_week_plus_2
, td.avg_mins_broadcast_week_plus_3 AS test_mins_broadcast_week_plus_3
, td.avg_mins_broadcast_week_plus_4 AS test_mins_broadcast_week_plus_4
, td.avg_mins_broadcast_week_plus_5 AS test_mins_broadcast_week_plus_5
, td.avg_mins_broadcast_week_plus_6 AS test_mins_broadcast_week_plus_6
, td.avg_mins_broadcast_week_plus_7 AS test_mins_broadcast_week_plus_7
, td.avg_mins_broadcast_week_plus_8 AS test_mins_broadcast_week_plus_8

, cd.avg_channel_rev_total_week_minus_8 AS control_rev_total_week_minus_8
, cd.avg_channel_rev_total_week_minus_7 AS control_rev_total_week_minus_7
, cd.avg_channel_rev_total_week_minus_6 AS control_rev_total_week_minus_6
, cd.avg_channel_rev_total_week_minus_5 AS control_rev_total_week_minus_5
, cd.avg_channel_rev_total_week_minus_4 AS control_rev_total_week_minus_4
, cd.avg_channel_rev_total_week_minus_3 AS control_rev_total_week_minus_3
, cd.avg_channel_rev_total_week_minus_2 AS control_rev_total_week_minus_2
, cd.avg_channel_rev_total_week_minus_1 AS control_rev_total_week_minus_1
, cd.avg_channel_rev_total_week_plus_1 AS control_rev_total_week_plus_1
, cd.avg_channel_rev_total_week_plus_2 AS control_rev_total_week_plus_2
, cd.avg_channel_rev_total_week_plus_3 AS control_rev_total_week_plus_3
, cd.avg_channel_rev_total_week_plus_4 AS control_rev_total_week_plus_4
, cd.avg_channel_rev_total_week_plus_5 AS control_rev_total_week_plus_5
, cd.avg_channel_rev_total_week_plus_6 AS control_rev_total_week_plus_6
, cd.avg_channel_rev_total_week_plus_7 AS control_rev_total_week_plus_7
, cd.avg_channel_rev_total_week_plus_8 AS control_rev_total_week_plus_8

, cd.avg_mins_watched_week_minus_8 AS control_mins_watched_week_minus_8
, cd.avg_mins_watched_week_minus_7 AS control_mins_watched_week_minus_7
, cd.avg_mins_watched_week_minus_6 AS control_mins_watched_week_minus_6
, cd.avg_mins_watched_week_minus_5 AS control_mins_watched_week_minus_5
, cd.avg_mins_watched_week_minus_4 AS control_mins_watched_week_minus_4
, cd.avg_mins_watched_week_minus_3 AS control_mins_watched_week_minus_3
, cd.avg_mins_watched_week_minus_2 AS control_mins_watched_week_minus_2
, cd.avg_mins_watched_week_minus_1 AS control_mins_watched_week_minus_1
, cd.avg_mins_watched_week_plus_1 AS control_mins_watched_week_plus_1
, cd.avg_mins_watched_week_plus_2 AS control_mins_watched_week_plus_2
, cd.avg_mins_watched_week_plus_3 AS control_mins_watched_week_plus_3
, cd.avg_mins_watched_week_plus_4 AS control_mins_watched_week_plus_4
, cd.avg_mins_watched_week_plus_5 AS control_mins_watched_week_plus_5
, cd.avg_mins_watched_week_plus_6 AS control_mins_watched_week_plus_6
, cd.avg_mins_watched_week_plus_7 AS control_mins_watched_week_plus_7
, cd.avg_mins_watched_week_plus_8 AS control_mins_watched_week_plus_8

, cd.avg_mins_broadcast_week_minus_8 AS control_mins_broadcast_week_minus_8
, cd.avg_mins_broadcast_week_minus_7 AS control_mins_broadcast_week_minus_7
, cd.avg_mins_broadcast_week_minus_6 AS control_mins_broadcast_week_minus_6
, cd.avg_mins_broadcast_week_minus_5 AS control_mins_broadcast_week_minus_5
, cd.avg_mins_broadcast_week_minus_4 AS control_mins_broadcast_week_minus_4
, cd.avg_mins_broadcast_week_minus_3 AS control_mins_broadcast_week_minus_3
, cd.avg_mins_broadcast_week_minus_2 AS control_mins_broadcast_week_minus_2
, cd.avg_mins_broadcast_week_minus_1 AS control_mins_broadcast_week_minus_1
, cd.avg_mins_broadcast_week_plus_1 AS control_mins_broadcast_week_plus_1
, cd.avg_mins_broadcast_week_plus_2 AS control_mins_broadcast_week_plus_2
, cd.avg_mins_broadcast_week_plus_3 AS control_mins_broadcast_week_plus_3
, cd.avg_mins_broadcast_week_plus_4 AS control_mins_broadcast_week_plus_4
, cd.avg_mins_broadcast_week_plus_5 AS control_mins_broadcast_week_plus_5
, cd.avg_mins_broadcast_week_plus_6 AS control_mins_broadcast_week_plus_6
, cd.avg_mins_broadcast_week_plus_7 AS control_mins_broadcast_week_plus_7
, cd.avg_mins_broadcast_week_plus_8 AS control_mins_broadcast_week_plus_8


FROM test_data AS td
LEFT JOIN control_data AS cd ON td.install_app_day=cd.day AND td.tier=cd.tier
--ORDER BY tier, day
)

SELECT tier, SUM(test_num_channels) AS test_num_channels, MIN(control_num_channels) AS control_num_channels
, AVG(test_rev_total_week_minus_8) AS test_rev_total_week_minus_8
, AVG(test_rev_total_week_minus_7) AS test_rev_total_week_minus_7
, AVG(test_rev_total_week_minus_6) AS test_rev_total_week_minus_6
, AVG(test_rev_total_week_minus_5) AS test_rev_total_week_minus_5
, AVG(test_rev_total_week_minus_4) AS test_rev_total_week_minus_4
, AVG(test_rev_total_week_minus_3) AS test_rev_total_week_minus_3
, AVG(test_rev_total_week_minus_2) AS test_rev_total_week_minus_2
, AVG(test_rev_total_week_minus_1) AS test_rev_total_week_minus_1
, AVG(test_rev_total_week_plus_1) AS test_rev_total_week_plus_1
, AVG(test_rev_total_week_plus_2) AS test_rev_total_week_plus_2
, AVG(test_rev_total_week_plus_3) AS test_rev_total_week_plus_3
, AVG(test_rev_total_week_plus_4) AS test_rev_total_week_plus_4
, AVG(test_rev_total_week_plus_5) AS test_rev_total_week_plus_5
, AVG(test_rev_total_week_plus_6) AS test_rev_total_week_plus_6
, AVG(test_rev_total_week_plus_7) AS test_rev_total_week_plus_7
, AVG(test_rev_total_week_plus_8) AS test_rev_total_week_plus_8

, AVG(test_mins_watched_week_minus_8) AS test_mins_watched_week_minus_8
, AVG(test_mins_watched_week_minus_7) AS test_mins_watched_week_minus_7
, AVG(test_mins_watched_week_minus_6) AS test_mins_watched_week_minus_6
, AVG(test_mins_watched_week_minus_5) AS test_mins_watched_week_minus_5
, AVG(test_mins_watched_week_minus_4) AS test_mins_watched_week_minus_4
, AVG(test_mins_watched_week_minus_3) AS test_mins_watched_week_minus_3
, AVG(test_mins_watched_week_minus_2) AS test_mins_watched_week_minus_2
, AVG(test_mins_watched_week_minus_1) AS test_mins_watched_week_minus_1
, AVG(test_mins_watched_week_plus_1) AS test_mins_watched_week_plus_1
, AVG(test_mins_watched_week_plus_2) AS test_mins_watched_week_plus_2
, AVG(test_mins_watched_week_plus_3) AS test_mins_watched_week_plus_3
, AVG(test_mins_watched_week_plus_4) AS test_mins_watched_week_plus_4
, AVG(test_mins_watched_week_plus_5) AS test_mins_watched_week_plus_5
, AVG(test_mins_watched_week_plus_6) AS test_mins_watched_week_plus_6
, AVG(test_mins_watched_week_plus_7) AS test_mins_watched_week_plus_7
, AVG(test_mins_watched_week_plus_8) AS test_mins_watched_week_plus_8

, AVG(test_mins_broadcast_week_minus_8) AS test_mins_broadcast_week_minus_8
, AVG(test_mins_broadcast_week_minus_7) AS test_mins_broadcast_week_minus_7
, AVG(test_mins_broadcast_week_minus_6) AS test_mins_broadcast_week_minus_6
, AVG(test_mins_broadcast_week_minus_5) AS test_mins_broadcast_week_minus_5
, AVG(test_mins_broadcast_week_minus_4) AS test_mins_broadcast_week_minus_4
, AVG(test_mins_broadcast_week_minus_3) AS test_mins_broadcast_week_minus_3
, AVG(test_mins_broadcast_week_minus_2) AS test_mins_broadcast_week_minus_2
, AVG(test_mins_broadcast_week_minus_1) AS test_mins_broadcast_week_minus_1
, AVG(test_mins_broadcast_week_plus_1) AS test_mins_broadcast_week_plus_1
, AVG(test_mins_broadcast_week_plus_2) AS test_mins_broadcast_week_plus_2
, AVG(test_mins_broadcast_week_plus_3) AS test_mins_broadcast_week_plus_3
, AVG(test_mins_broadcast_week_plus_4) AS test_mins_broadcast_week_plus_4
, AVG(test_mins_broadcast_week_plus_5) AS test_mins_broadcast_week_plus_5
, AVG(test_mins_broadcast_week_plus_6) AS test_mins_broadcast_week_plus_6
, AVG(test_mins_broadcast_week_plus_7) AS test_mins_broadcast_week_plus_7
, AVG(test_mins_broadcast_week_plus_8) AS test_mins_broadcast_week_plus_8

, AVG(control_rev_total_week_minus_8) AS control_rev_total_week_minus_8
, AVG(control_rev_total_week_minus_7) AS control_rev_total_week_minus_7
, AVG(control_rev_total_week_minus_6) AS control_rev_total_week_minus_6
, AVG(control_rev_total_week_minus_5) AS control_rev_total_week_minus_5
, AVG(control_rev_total_week_minus_4) AS control_rev_total_week_minus_4
, AVG(control_rev_total_week_minus_3) AS control_rev_total_week_minus_3
, AVG(control_rev_total_week_minus_2) AS control_rev_total_week_minus_2
, AVG(control_rev_total_week_minus_1) AS control_rev_total_week_minus_1
, AVG(control_rev_total_week_plus_1) AS control_rev_total_week_plus_1
, AVG(control_rev_total_week_plus_2) AS control_rev_total_week_plus_2
, AVG(control_rev_total_week_plus_3) AS control_rev_total_week_plus_3
, AVG(control_rev_total_week_plus_4) AS control_rev_total_week_plus_4
, AVG(control_rev_total_week_plus_5) AS control_rev_total_week_plus_5
, AVG(control_rev_total_week_plus_6) AS control_rev_total_week_plus_6
, AVG(control_rev_total_week_plus_7) AS control_rev_total_week_plus_7
, AVG(control_rev_total_week_plus_8) AS control_rev_total_week_plus_8

, AVG(control_mins_watched_week_minus_8) AS control_mins_watched_week_minus_8
, AVG(control_mins_watched_week_minus_7) AS control_mins_watched_week_minus_7
, AVG(control_mins_watched_week_minus_6) AS control_mins_watched_week_minus_6
, AVG(control_mins_watched_week_minus_5) AS control_mins_watched_week_minus_5
, AVG(control_mins_watched_week_minus_4) AS control_mins_watched_week_minus_4
, AVG(control_mins_watched_week_minus_3) AS control_mins_watched_week_minus_3
, AVG(control_mins_watched_week_minus_2) AS control_mins_watched_week_minus_2
, AVG(control_mins_watched_week_minus_1) AS control_mins_watched_week_minus_1
, AVG(control_mins_watched_week_plus_1) AS control_mins_watched_week_plus_1
, AVG(control_mins_watched_week_plus_2) AS control_mins_watched_week_plus_2
, AVG(control_mins_watched_week_plus_3) AS control_mins_watched_week_plus_3
, AVG(control_mins_watched_week_plus_4) AS control_mins_watched_week_plus_4
, AVG(control_mins_watched_week_plus_5) AS control_mins_watched_week_plus_5
, AVG(control_mins_watched_week_plus_6) AS control_mins_watched_week_plus_6
, AVG(control_mins_watched_week_plus_7) AS control_mins_watched_week_plus_7
, AVG(control_mins_watched_week_plus_8) AS control_mins_watched_week_plus_8

, AVG(control_mins_broadcast_week_minus_8) AS control_mins_broadcast_week_minus_8
, AVG(control_mins_broadcast_week_minus_7) AS control_mins_broadcast_week_minus_7
, AVG(control_mins_broadcast_week_minus_6) AS control_mins_broadcast_week_minus_6
, AVG(control_mins_broadcast_week_minus_5) AS control_mins_broadcast_week_minus_5
, AVG(control_mins_broadcast_week_minus_4) AS control_mins_broadcast_week_minus_4
, AVG(control_mins_broadcast_week_minus_3) AS control_mins_broadcast_week_minus_3
, AVG(control_mins_broadcast_week_minus_2) AS control_mins_broadcast_week_minus_2
, AVG(control_mins_broadcast_week_minus_1) AS control_mins_broadcast_week_minus_1
, AVG(control_mins_broadcast_week_plus_1) AS control_mins_broadcast_week_plus_1
, AVG(control_mins_broadcast_week_plus_2) AS control_mins_broadcast_week_plus_2
, AVG(control_mins_broadcast_week_plus_3) AS control_mins_broadcast_week_plus_3
, AVG(control_mins_broadcast_week_plus_4) AS control_mins_broadcast_week_plus_4
, AVG(control_mins_broadcast_week_plus_5) AS control_mins_broadcast_week_plus_5
, AVG(control_mins_broadcast_week_plus_6) AS control_mins_broadcast_week_plus_6
, AVG(control_mins_broadcast_week_plus_7) AS control_mins_broadcast_week_plus_7
, AVG(control_mins_broadcast_week_plus_8) AS control_mins_broadcast_week_plus_8

FROM test_join_control
GROUP BY tier
ORDER BY tier
--
-- SELECT * FROM test_data ORDER BY install_app_day, tier
