-- by yanghung
-- generate broadcaster control lookup data (never ever linked to streamlabs or muxy) that contains tiers
DROP TABLE IF EXISTS    analysis.panalysis879_broadcaster_control;
CREATE TABLE    analysis.panalysis879_broadcaster_control    AS


WITH
potential_broadcasters AS (
  SELECT * FROM analysis.panalysis879_oauth_streamlabs_muxy
)


SELECT pb.*, bt.channel_id, NVL(bt.mw,0) AS mw, NVL(bt.mb,0) AS mb, NVL(bt.avg_ccu, -1) AS avg_ccu, NVL(bt.tier,'not broadcasting') AS tier
FROM potential_broadcasters AS pb
RIGHT JOIN analysis.panalysis879_broadcaster_tier_list AS bt ON pb.user_id=bt.channel_id
WHERE pb.streamlabs_min_time IS NULL AND pb.muxy_min_time IS NULL
-- join pb with bt, then take only those broadcasters that don't have dates for streamlabs and muxy (i.e. never activated)
AND bt.channel_id NOT IN (SELECT DISTINCT broadcaster_twitch_id FROM analysis.panalysis879_tips_log WHERE flag_transaction='good')
-- channel_id should never have gotten a tip from muxy/streamlabs data

;
