-- Test to display some summary stats of test vs control
WITH
the_control AS (
  SELECT 'control' AS the_group, tier, COUNT(1) as num_rows, COUNT(DISTINCT channel_id) as num_users, AVG(avg_ccu) AS avgs_ccu, AVG(mw) as avg_mw, AVG(mb) as avg_mb
  FROM
  (
  SELECT * FROM analysis.panalysis879_broadcaster_control
  )
  GROUP BY tier
)

, the_test AS (
  SELECT 'test' AS the_group, tier, COUNT(1) as num_rows, COUNT(DISTINCT user_id) as num_users, AVG(avg_ccu) AS avgs_ccu, AVG(mw) as avg_mw, AVG(mb) as avg_mb
  FROM
  (
  SELECT * FROM analysis.panalysis879_broadcaster_test
  )
  GROUP BY tier
)

SELECT *
FROM
(
SELECT * FROM the_control
UNION ALL
SELECT * FROM the_test
)
ORDER BY the_group,tier
;
