-- DEPRECATE TESTING ONLY




WITH
broadcast_log AS (
  SELECT *
  , PERCENTILE_CONT(0.10) WITHIN GROUP (ORDER BY mins_broadcast) OVER (PARTITION BY the_group, tier) AS mins_10_pctile
  , PERCENTILE_CONT(0.25) WITHIN GROUP (ORDER BY mins_broadcast) OVER (PARTITION BY the_group, tier) AS mins_25_pctile
  , PERCENTILE_CONT(0.50) WITHIN GROUP (ORDER BY mins_broadcast) OVER (PARTITION BY the_group, tier) AS mins_50_pctile
  , PERCENTILE_CONT(0.75) WITHIN GROUP (ORDER BY mins_broadcast) OVER (PARTITION BY the_group, tier) AS mins_75_pctile
  , PERCENTILE_CONT(0.90) WITHIN GROUP (ORDER BY mins_broadcast) OVER (PARTITION BY the_group, tier) AS mins_90_pctile
  , PERCENTILE_CONT(1.00) WITHIN GROUP (ORDER BY mins_broadcast) OVER (PARTITION BY the_group, tier) AS mins_100_pctile
  FROM analysis.panalysis879_broadcaster_broadcast_log

)

SELECT the_group, tier, COUNT(DISTINCT channel_id) AS num_channels, SUM(mins_broadcast) AS total_mins
, SUM(mins_broadcast)::FLOAT/COUNT(DISTINCT channel_id)::FLOAT AS avg_min_per_channel
, MIN(mins_50_pctile) AS min_median, MAX(mins_50_pctile) AS max_median

FROM broadcast_log--analysis.panalysis879_broadcaster_broadcast_log
GROUP BY 1,2
ORDER BY 1,2
;
