-- by yanghung
-- generate broadcaster control lookup data (never ever linked to streamlabs or muxy) that contains tiers
-- NOTE: For some reason we need to cast as text to that the UNION ALL works correctly
-- BUG: streamlabs has lots of records where broadcaster and viewer id is the same...
DROP TABLE IF EXISTS    analysis.panalysis879_tips_log;
CREATE TABLE    analysis.panalysis879_tips_log    AS

WITH
tips_streamlabs AS (
SELECT created_at::timestamp AS "time", broadcaster_twitch_id::TEXT, viewer_twitch_id::TEXT, usd_amount, 'streamlabs'::text AS platform
FROM analysis.streamlabs_tip_log
WHERE usd_amount>0
AND created_at>='2016-07-26' --streamlabs only has data from July 2016 onward
AND created_at<='2017-06-27' --streamlabs only has data until June 2017
)
, tips_muxy AS (
SELECT "time"::timestamp AS "time", channel_id::TEXT AS broadcaster_twitch_id, NVL(su.user_id,-1)::TEXT AS viewer_twitch_id, amount_usd AS usd_amount, 'muxy'::text AS platform
FROM analysis.muxy_tip_log AS mtl
LEFT JOIN analysis.sitedb_users AS su ON LOWER(mtl.donor) = su.login
WHERE amount_usd>0
AND "time">='2016-07-26' --streamlabs only has data from July 2016 onward
AND "time"<='2017-06-27' --streamlabs only has data until June 2017
)

SELECT *,
CASE WHEN usd_amount>100000 THEN 'bad' ELSE 'good' END AS flag_transaction
FROM
(
SELECT * FROM tips_streamlabs
UNION ALL
SELECT * FROM tips_muxy
)
;
