-- Test tiers and the avg rev stats
-- BUG: WHy does taking out channel_rev_ads from the equation lead to HIGHER revenue??

WITH
rev_log AS (
SELECT rev.channel_id, idd.tier, idd.the_group, rev.day,channel_rev_ads, channel_rev_prime_sub, channel_rev_paid_sub, channel_rev_bits, channel_rev_donation_muxy, channel_rev_donation_streamlabs

, NVL(rev.channel_rev_donation_muxy,0)::REAL+NVL(rev.channel_rev_donation_streamlabs,0)::REAL AS channel_rev_off_twitch
, rev.channel_rev_ads::REAL+rev.channel_rev_prime_sub::REAL+rev.channel_rev_paid_sub::REAL+rev.channel_rev_bits::REAL AS channel_rev_on_twitch
, rev.channel_rev_ads::REAL+rev.channel_rev_prime_sub::REAL+rev.channel_rev_paid_sub::REAL+rev.channel_rev_bits::REAL+NVL(rev.channel_rev_donation_muxy,0)::REAL+NVL(rev.channel_rev_donation_streamlabs,0)::REAL AS channel_rev_total

FROM analysis.panalysis879_broadcaster_rev_by_day rev
LEFT JOIN analysis.panalysis879_broadcaster_test_control_ids idd ON rev.channel_id=idd.channel_id
)


SELECT tier, the_group, COUNT(DISTINCT channel_id) as channels

, SUM(channel_rev_ads) AS ads_rev
, SUM(channel_rev_total) AS sum_1
, SUM(channel_rev_ads::REAL+channel_rev_prime_sub::REAL+channel_rev_paid_sub::REAL+channel_rev_bits::REAL+NVL(channel_rev_donation_muxy,0)::REAL+NVL(channel_rev_donation_streamlabs,0)::REAL) AS sum_2
, SUM(channel_rev_prime_sub::REAL+channel_rev_paid_sub::REAL+channel_rev_bits::REAL+NVL(channel_rev_donation_muxy,0)::REAL+NVL(channel_rev_donation_streamlabs,0)::REAL) AS sum_3
, SUM(channel_rev_total)/COUNT(DISTINCT channel_id) AS the_real_avg_rev
, SUM(channel_rev_ads+channel_rev_prime_sub+channel_rev_paid_sub+channel_rev_bits+NVL(channel_rev_donation_muxy,0)+NVL(channel_rev_donation_streamlabs,0))/COUNT(DISTINCT channel_id)  AS real_avg
FROM rev_log
GROUP BY tier, the_group
ORDER BY 2,1
