-- by yanghung
-- generate broadcaster revenue by day data

DROP TABLE IF EXISTS    analysis.panalysis879_broadcaster_daily_metrics;
CREATE TABLE    analysis.panalysis879_broadcaster_daily_metrics    AS


WITH
rev_data AS (SELECT * FROM analysis.panalysis879_broadcaster_rev_by_day)
, mb_data AS (
  SELECT channel_id, day, channel_name_lower AS channel
  , SUM(mins_broadcast) AS mins_broadcast
  FROM analysis.panalysis879_broadcaster_broadcast_log
  GROUP BY 1,2,3
)
, mw_data AS (
  -- NOTE: don’t add up live and vod to get total mw, these were previously mutually exclusive now they aren’t due to VODCAST (vodcast is a live, synchronous airing of a VOD)
  SELECT channel_id, day, channel
  -- , SUM(mw_live_frontpage) AS mw_live_frontpage
  -- , SUM(mw_live_non_frontpage) AS mw_live_non_frontpage
  -- , SUM(mw_live_total) AS mw_live_total
  -- , SUM(mw_vod_total) AS mw_vod_total
  , SUM(mw_total) AS mins_watched -- use this for total mw
  FROM analysis.agg_daily_minutes_watched_by_channel
  GROUP BY 1,2,3
)

SELECT base.the_group, base.channel_id, base.tier
, DATE(sm.abs_min_time) AS install_app_day
, mw.day, DATE_TRUNC('week', mw.day) AS the_week
, TO_CHAR(DATE_TRUNC('week', mw.day) - INTERVAL '1 days', 'WW: Mon DD, YYYY') || ' - ' || TO_CHAR(DATE_TRUNC('week', mw.day) + INTERVAL '5 days', 'Mon DD, YYYY') AS the_week_range
, mw.channel, mw.mins_watched, mb.mins_broadcast
, NVL(rev.channel_rev_ads,0)::REAL AS channel_rev_ads
, NVL(rev.channel_rev_prime_sub,0)::REAL AS channel_rev_prime_sub
, NVL(rev.channel_rev_paid_sub,0)::REAL AS channel_rev_paid_sub
, NVL(rev.channel_rev_bits,0)::REAL AS channel_rev_bits
, NVL(rev.channel_rev_donation_muxy,0)::REAL AS channel_rev_donation_muxy
, NVL(rev.channel_rev_donation_streamlabs,0)::REAL AS channel_rev_donation_streamlabs
, NVL(rev.channel_rev_donation_muxy,0)::REAL+NVL(rev.channel_rev_donation_streamlabs,0)::REAL AS channel_rev_off_twitch
, NVL(rev.channel_rev_ads,0)::REAL+NVL(rev.channel_rev_prime_sub,0)::REAL+NVL(rev.channel_rev_paid_sub,0)+NVL(rev.channel_rev_bits,0)::REAL AS channel_rev_on_twitch
, NVL(rev.channel_rev_ads,0)::REAL+NVL(rev.channel_rev_prime_sub,0)::REAL+NVL(rev.channel_rev_paid_sub,0)+NVL(rev.channel_rev_bits,0)::REAL+NVL(rev.channel_rev_donation_muxy,0)::REAL+NVL(rev.channel_rev_donation_streamlabs,0)::REAL AS channel_rev_total
FROM analysis.panalysis879_broadcaster_test_control_ids AS base
LEFT JOIN analysis.panalysis879_oauth_streamlabs_muxy AS sm ON base.channel_id = sm.user_id
LEFT JOIN mw_data AS mw ON base.channel_id=mw.channel_id
LEFT JOIN mb_data AS mb ON mw.channel_id=mb.channel_id AND mw.day=mb.day
LEFT JOIN rev_data AS rev ON mw.channel_id=rev.channel_id AND mw.day=rev.day
WHERE base.tier<>'not broadcasting'
AND mw.day>='2016-01-01'
;
