



WITH
rev_log AS (
SELECT rev.channel_id, rev.tier, rev.the_group, rev.day
, NVL(rev.channel_rev_ads,0)::REAL AS channel_rev_ads
, NVL(rev.channel_rev_prime_sub,0)::REAL AS channel_rev_prime_sub
, NVL(rev.channel_rev_paid_sub,0)::REAL AS channel_rev_paid_sub
, NVL(rev.channel_rev_bits,0)::REAL AS channel_rev_bits
, NVL(rev.channel_rev_donation_muxy,0)::REAL AS channel_rev_donation_muxy
, NVL(rev.channel_rev_donation_streamlabs,0)::REAL AS channel_rev_donation_streamlabs
, NVL(rev.channel_rev_donation_muxy,0)::REAL+NVL(rev.channel_rev_donation_streamlabs,0)::REAL AS channel_rev_off_twitch
, NVL(rev.channel_rev_ads,0)::REAL+NVL(rev.channel_rev_prime_sub,0)::REAL+NVL(rev.channel_rev_paid_sub,0)+NVL(rev.channel_rev_bits,0)::REAL AS channel_rev_on_twitch
, NVL(rev.channel_rev_ads,0)::REAL+NVL(rev.channel_rev_prime_sub,0)::REAL+NVL(rev.channel_rev_paid_sub,0)+NVL(rev.channel_rev_bits,0)::REAL+NVL(rev.channel_rev_donation_muxy,0)::REAL+NVL(rev.channel_rev_donation_streamlabs,0)::REAL AS channel_rev_total
FROM analysis.panalysis879_broadcaster_rev_by_day rev
)


SELECT * FROM (
SELECT 'step5' as step, tier, the_group, COUNT(DISTINCT channel_id) as channels
, SUM(channel_rev_total) AS channel_rev_total
, SUM(channel_rev_ads+channel_rev_prime_sub+channel_rev_paid_sub+channel_rev_bits+channel_rev_donation_muxy+channel_rev_donation_streamlabs) AS channel_rev_total_calc

, SUM(channel_rev_on_twitch) AS channel_rev_on_twitch
, SUM(channel_rev_ads+channel_rev_prime_sub+channel_rev_paid_sub+channel_rev_bits) AS channel_rev_on_twitch_calc

, SUM(channel_rev_ads) AS channel_rev_ads
, SUM(channel_rev_prime_sub+channel_rev_paid_sub+channel_rev_bits+channel_rev_donation_muxy+channel_rev_donation_streamlabs) AS channel_rev_no_ads

, SUM(channel_rev_off_twitch) AS donation_rev
, SUM(channel_rev_donation_muxy+channel_rev_donation_streamlabs) AS donation_rev_calc
, SUM(channel_rev_ads+channel_rev_prime_sub+channel_rev_paid_sub+channel_rev_bits) AS channel_rev_no_donation

, SUM(channel_rev_total)/COUNT(DISTINCT channel_id) AS the_real_avg_rev
, SUM(channel_rev_ads+channel_rev_prime_sub+channel_rev_paid_sub+channel_rev_bits+channel_rev_donation_muxy+channel_rev_donation_streamlabs)/COUNT(DISTINCT channel_id)  AS real_avg
FROM rev_log
WHERE tier<>'not broadcasting'
GROUP BY tier, the_group


UNION ALL

SELECT 'step6' as step, tier, the_group, COUNT(DISTINCT channel_id) as channels
, SUM(channel_rev_total) AS channel_rev_total
, SUM(channel_rev_ads+channel_rev_prime_sub+channel_rev_paid_sub+channel_rev_bits+channel_rev_donation_muxy+channel_rev_donation_streamlabs) AS channel_rev_total_calc

, SUM(channel_rev_on_twitch) AS channel_rev_on_twitch
, SUM(channel_rev_ads+channel_rev_prime_sub+channel_rev_paid_sub+channel_rev_bits) AS channel_rev_on_twitch_calc

, SUM(channel_rev_ads) AS channel_rev_ads
, SUM(channel_rev_prime_sub+channel_rev_paid_sub+channel_rev_bits+channel_rev_donation_muxy+channel_rev_donation_streamlabs) AS channel_rev_no_ads

, SUM(channel_rev_off_twitch) AS donation_rev
, SUM(channel_rev_donation_muxy+channel_rev_donation_streamlabs) AS donation_rev_calc
, SUM(channel_rev_ads+channel_rev_prime_sub+channel_rev_paid_sub+channel_rev_bits) AS channel_rev_no_donation

, SUM(channel_rev_total)/COUNT(DISTINCT channel_id) AS the_real_avg_rev
, SUM(channel_rev_ads+channel_rev_prime_sub+channel_rev_paid_sub+channel_rev_bits+channel_rev_donation_muxy+channel_rev_donation_streamlabs)/COUNT(DISTINCT channel_id)  AS real_avg
FROM analysis.panalysis879_broadcaster_daily_metrics
WHERE tier<>'not broadcasting'
GROUP BY tier, the_group
)
ORDER BY 1,3,2
