-- by yanghung
-- generate lookup to see t-4, t-3, t-2....t+3, t+4 stats for each 'control' channel and each "day"
-- day is ranged between since that's what the muxy

DROP TABLE IF EXISTS    analysis.panalysis879_broadcaster_weekly_lookup;
CREATE TABLE    analysis.panalysis879_broadcaster_weekly_lookup    AS

WITH
all_days AS (
  SELECT DISTINCT day FROM analysis.panalysis879_broadcaster_daily_metrics WHERE day>='2016-04-01' --streamlabs only has data from July 2016 onward, then take a 3 month buffer
)
, all_channels AS (
  SELECT DISTINCT channel_id FROM analysis.panalysis879_broadcaster_daily_metrics
)
, all_channel_days AS (
  SELECT ad.day, ac.channel_id FROM all_days AS ad CROSS JOIN all_channels ac
)
, full_daily_metrics AS (
  SELECT acd.day, acd.channel_id, dm.channel, dm.the_group, dm.tier
  , dm.mins_watched
  , dm.mins_broadcast
  , dm.channel_rev_ads
  , dm.channel_rev_prime_sub
  , dm.channel_rev_paid_sub
  , dm.channel_rev_bits
  , dm.channel_rev_donation_muxy
  , dm.channel_rev_donation_streamlabs
  , dm.channel_rev_off_twitch
  , dm.channel_rev_on_twitch
  , dm.channel_rev_total
  FROM all_channel_days AS acd
  LEFT JOIN analysis.panalysis879_broadcaster_daily_metrics AS dm ON acd.channel_id=dm.channel_id AND acd.day=dm.day
)

SELECT day, channel_id, channel, the_group, tier

, SUM(mins_watched) AS mins_watched
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 56 PRECEDING AND 50 PRECEDING) AS mins_watched_week_minus_8
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 PRECEDING AND 43 PRECEDING) AS mins_watched_week_minus_7
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 PRECEDING AND 36 PRECEDING) AS mins_watched_week_minus_6
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 PRECEDING AND 29 PRECEDING) AS mins_watched_week_minus_5
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 PRECEDING AND 22 PRECEDING) AS mins_watched_week_minus_4
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 PRECEDING AND 15 PRECEDING) AS mins_watched_week_minus_3
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 PRECEDING AND 8 PRECEDING) AS mins_watched_week_minus_2
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 PRECEDING AND 1 PRECEDING) AS mins_watched_week_minus_1
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN CURRENT ROW AND 6 FOLLOWING) AS mins_watched_week_plus_1
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 FOLLOWING AND 13 FOLLOWING) AS mins_watched_week_plus_2
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 FOLLOWING AND 20 FOLLOWING) AS mins_watched_week_plus_3
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 FOLLOWING AND 27 FOLLOWING) AS mins_watched_week_plus_4
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 FOLLOWING AND 34 FOLLOWING) AS mins_watched_week_plus_5
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 FOLLOWING AND 41 FOLLOWING) AS mins_watched_week_plus_6
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 FOLLOWING AND 48 FOLLOWING) AS mins_watched_week_plus_7
, SUM(mins_watched) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 FOLLOWING AND 55 FOLLOWING) AS mins_watched_week_plus_8

, SUM(mins_broadcast) AS mins_broadcast
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 56 PRECEDING AND 50 PRECEDING) AS mins_broadcast_week_minus_8
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 PRECEDING AND 43 PRECEDING) AS mins_broadcast_week_minus_7
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 PRECEDING AND 36 PRECEDING) AS mins_broadcast_week_minus_6
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 PRECEDING AND 29 PRECEDING) AS mins_broadcast_week_minus_5
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 PRECEDING AND 22 PRECEDING) AS mins_broadcast_week_minus_4
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 PRECEDING AND 15 PRECEDING) AS mins_broadcast_week_minus_3
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 PRECEDING AND 8 PRECEDING) AS mins_broadcast_week_minus_2
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 PRECEDING AND 1 PRECEDING) AS mins_broadcast_week_minus_1
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN CURRENT ROW AND 6 FOLLOWING) AS mins_broadcast_week_plus_1
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 FOLLOWING AND 13 FOLLOWING) AS mins_broadcast_week_plus_2
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 FOLLOWING AND 20 FOLLOWING) AS mins_broadcast_week_plus_3
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 FOLLOWING AND 27 FOLLOWING) AS mins_broadcast_week_plus_4
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 FOLLOWING AND 34 FOLLOWING) AS mins_broadcast_week_plus_5
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 FOLLOWING AND 41 FOLLOWING) AS mins_broadcast_week_plus_6
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 FOLLOWING AND 48 FOLLOWING) AS mins_broadcast_week_plus_7
, SUM(mins_broadcast) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 FOLLOWING AND 55 FOLLOWING) AS mins_broadcast_week_plus_8

, SUM(channel_rev_ads) AS channel_rev_ads
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 56 PRECEDING AND 50 PRECEDING) AS channel_rev_ads_week_minus_8
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 PRECEDING AND 43 PRECEDING) AS channel_rev_ads_week_minus_7
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 PRECEDING AND 36 PRECEDING) AS channel_rev_ads_week_minus_6
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 PRECEDING AND 29 PRECEDING) AS channel_rev_ads_week_minus_5
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 PRECEDING AND 22 PRECEDING) AS channel_rev_ads_week_minus_4
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 PRECEDING AND 15 PRECEDING) AS channel_rev_ads_week_minus_3
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 PRECEDING AND 8 PRECEDING) AS channel_rev_ads_week_minus_2
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 PRECEDING AND 1 PRECEDING) AS channel_rev_ads_week_minus_1
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN CURRENT ROW AND 6 FOLLOWING) AS channel_rev_ads_week_plus_1
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 FOLLOWING AND 13 FOLLOWING) AS channel_rev_ads_week_plus_2
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 FOLLOWING AND 20 FOLLOWING) AS channel_rev_ads_week_plus_3
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 FOLLOWING AND 27 FOLLOWING) AS channel_rev_ads_week_plus_4
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 FOLLOWING AND 34 FOLLOWING) AS channel_rev_ads_week_plus_5
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 FOLLOWING AND 41 FOLLOWING) AS channel_rev_ads_week_plus_6
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 FOLLOWING AND 48 FOLLOWING) AS channel_rev_ads_week_plus_7
, SUM(channel_rev_ads) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 FOLLOWING AND 55 FOLLOWING) AS channel_rev_ads_week_plus_8

, SUM(channel_rev_prime_sub) AS channel_rev_prime_sub
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 56 PRECEDING AND 50 PRECEDING) AS channel_rev_prime_sub_week_minus_8
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 PRECEDING AND 43 PRECEDING) AS channel_rev_prime_sub_week_minus_7
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 PRECEDING AND 36 PRECEDING) AS channel_rev_prime_sub_week_minus_6
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 PRECEDING AND 29 PRECEDING) AS channel_rev_prime_sub_week_minus_5
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 PRECEDING AND 22 PRECEDING) AS channel_rev_prime_sub_week_minus_4
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 PRECEDING AND 15 PRECEDING) AS channel_rev_prime_sub_week_minus_3
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 PRECEDING AND 8 PRECEDING) AS channel_rev_prime_sub_week_minus_2
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 PRECEDING AND 1 PRECEDING) AS channel_rev_prime_sub_week_minus_1
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN CURRENT ROW AND 6 FOLLOWING) AS channel_rev_prime_sub_week_plus_1
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 FOLLOWING AND 13 FOLLOWING) AS channel_rev_prime_sub_week_plus_2
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 FOLLOWING AND 20 FOLLOWING) AS channel_rev_prime_sub_week_plus_3
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 FOLLOWING AND 27 FOLLOWING) AS channel_rev_prime_sub_week_plus_4
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 FOLLOWING AND 34 FOLLOWING) AS channel_rev_prime_sub_week_plus_5
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 FOLLOWING AND 41 FOLLOWING) AS channel_rev_prime_sub_week_plus_6
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 FOLLOWING AND 48 FOLLOWING) AS channel_rev_prime_sub_week_plus_7
, SUM(channel_rev_prime_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 FOLLOWING AND 55 FOLLOWING) AS channel_rev_prime_sub_week_plus_8

, SUM(channel_rev_paid_sub) AS channel_rev_paid_sub
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 56 PRECEDING AND 50 PRECEDING) AS channel_rev_paid_sub_week_minus_8
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 PRECEDING AND 43 PRECEDING) AS channel_rev_paid_sub_week_minus_7
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 PRECEDING AND 36 PRECEDING) AS channel_rev_paid_sub_week_minus_6
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 PRECEDING AND 29 PRECEDING) AS channel_rev_paid_sub_week_minus_5
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 PRECEDING AND 22 PRECEDING) AS channel_rev_paid_sub_week_minus_4
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 PRECEDING AND 15 PRECEDING) AS channel_rev_paid_sub_week_minus_3
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 PRECEDING AND 8 PRECEDING) AS channel_rev_paid_sub_week_minus_2
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 PRECEDING AND 1 PRECEDING) AS channel_rev_paid_sub_week_minus_1
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN CURRENT ROW AND 6 FOLLOWING) AS channel_rev_paid_sub_week_plus_1
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 FOLLOWING AND 13 FOLLOWING) AS channel_rev_paid_sub_week_plus_2
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 FOLLOWING AND 20 FOLLOWING) AS channel_rev_paid_sub_week_plus_3
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 FOLLOWING AND 27 FOLLOWING) AS channel_rev_paid_sub_week_plus_4
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 FOLLOWING AND 34 FOLLOWING) AS channel_rev_paid_sub_week_plus_5
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 FOLLOWING AND 41 FOLLOWING) AS channel_rev_paid_sub_week_plus_6
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 FOLLOWING AND 48 FOLLOWING) AS channel_rev_paid_sub_week_plus_7
, SUM(channel_rev_paid_sub) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 FOLLOWING AND 55 FOLLOWING) AS channel_rev_paid_sub_week_plus_8

, SUM(channel_rev_bits) AS channel_rev_bits
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 56 PRECEDING AND 50 PRECEDING) AS channel_rev_bits_week_minus_8
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 PRECEDING AND 43 PRECEDING) AS channel_rev_bits_week_minus_7
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 PRECEDING AND 36 PRECEDING) AS channel_rev_bits_week_minus_6
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 PRECEDING AND 29 PRECEDING) AS channel_rev_bits_week_minus_5
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 PRECEDING AND 22 PRECEDING) AS channel_rev_bits_week_minus_4
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 PRECEDING AND 15 PRECEDING) AS channel_rev_bits_week_minus_3
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 PRECEDING AND 8 PRECEDING) AS channel_rev_bits_week_minus_2
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 PRECEDING AND 1 PRECEDING) AS channel_rev_bits_week_minus_1
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN CURRENT ROW AND 6 FOLLOWING) AS channel_rev_bits_week_plus_1
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 FOLLOWING AND 13 FOLLOWING) AS channel_rev_bits_week_plus_2
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 FOLLOWING AND 20 FOLLOWING) AS channel_rev_bits_week_plus_3
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 FOLLOWING AND 27 FOLLOWING) AS channel_rev_bits_week_plus_4
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 FOLLOWING AND 34 FOLLOWING) AS channel_rev_bits_week_plus_5
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 FOLLOWING AND 41 FOLLOWING) AS channel_rev_bits_week_plus_6
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 FOLLOWING AND 48 FOLLOWING) AS channel_rev_bits_week_plus_7
, SUM(channel_rev_bits) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 FOLLOWING AND 55 FOLLOWING) AS channel_rev_bits_week_plus_8

, SUM(channel_rev_donation_muxy) AS channel_rev_donation_muxy
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 56 PRECEDING AND 50 PRECEDING) AS channel_rev_donation_muxy_week_minus_8
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 PRECEDING AND 43 PRECEDING) AS channel_rev_donation_muxy_week_minus_7
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 PRECEDING AND 36 PRECEDING) AS channel_rev_donation_muxy_week_minus_6
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 PRECEDING AND 29 PRECEDING) AS channel_rev_donation_muxy_week_minus_5
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 PRECEDING AND 22 PRECEDING) AS channel_rev_donation_muxy_week_minus_4
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 PRECEDING AND 15 PRECEDING) AS channel_rev_donation_muxy_week_minus_3
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 PRECEDING AND 8 PRECEDING) AS channel_rev_donation_muxy_week_minus_2
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 PRECEDING AND 1 PRECEDING) AS channel_rev_donation_muxy_week_minus_1
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN CURRENT ROW AND 6 FOLLOWING) AS channel_rev_donation_muxy_week_plus_1
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 FOLLOWING AND 13 FOLLOWING) AS channel_rev_donation_muxy_week_plus_2
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 FOLLOWING AND 20 FOLLOWING) AS channel_rev_donation_muxy_week_plus_3
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 FOLLOWING AND 27 FOLLOWING) AS channel_rev_donation_muxy_week_plus_4
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 FOLLOWING AND 34 FOLLOWING) AS channel_rev_donation_muxy_week_plus_5
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 FOLLOWING AND 41 FOLLOWING) AS channel_rev_donation_muxy_week_plus_6
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 FOLLOWING AND 48 FOLLOWING) AS channel_rev_donation_muxy_week_plus_7
, SUM(channel_rev_donation_muxy) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 FOLLOWING AND 55 FOLLOWING) AS channel_rev_donation_muxy_week_plus_8

, SUM(channel_rev_donation_streamlabs) AS channel_rev_donation_streamlabs
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 56 PRECEDING AND 50 PRECEDING) AS channel_rev_donation_streamlabs_week_minus_8
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 PRECEDING AND 43 PRECEDING) AS channel_rev_donation_streamlabs_week_minus_7
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 PRECEDING AND 36 PRECEDING) AS channel_rev_donation_streamlabs_week_minus_6
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 PRECEDING AND 29 PRECEDING) AS channel_rev_donation_streamlabs_week_minus_5
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 PRECEDING AND 22 PRECEDING) AS channel_rev_donation_streamlabs_week_minus_4
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 PRECEDING AND 15 PRECEDING) AS channel_rev_donation_streamlabs_week_minus_3
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 PRECEDING AND 8 PRECEDING) AS channel_rev_donation_streamlabs_week_minus_2
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 PRECEDING AND 1 PRECEDING) AS channel_rev_donation_streamlabs_week_minus_1
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN CURRENT ROW AND 6 FOLLOWING) AS channel_rev_donation_streamlabs_week_plus_1
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 FOLLOWING AND 13 FOLLOWING) AS channel_rev_donation_streamlabs_week_plus_2
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 FOLLOWING AND 20 FOLLOWING) AS channel_rev_donation_streamlabs_week_plus_3
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 FOLLOWING AND 27 FOLLOWING) AS channel_rev_donation_streamlabs_week_plus_4
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 FOLLOWING AND 34 FOLLOWING) AS channel_rev_donation_streamlabs_week_plus_5
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 FOLLOWING AND 41 FOLLOWING) AS channel_rev_donation_streamlabs_week_plus_6
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 FOLLOWING AND 48 FOLLOWING) AS channel_rev_donation_streamlabs_week_plus_7
, SUM(channel_rev_donation_streamlabs) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 FOLLOWING AND 55 FOLLOWING) AS channel_rev_donation_streamlabs_week_plus_8

, SUM(channel_rev_off_twitch) AS channel_rev_off_twitch
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 56 PRECEDING AND 50 PRECEDING) AS channel_rev_off_twitch_week_minus_8
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 PRECEDING AND 43 PRECEDING) AS channel_rev_off_twitch_week_minus_7
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 PRECEDING AND 36 PRECEDING) AS channel_rev_off_twitch_week_minus_6
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 PRECEDING AND 29 PRECEDING) AS channel_rev_off_twitch_week_minus_5
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 PRECEDING AND 22 PRECEDING) AS channel_rev_off_twitch_week_minus_4
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 PRECEDING AND 15 PRECEDING) AS channel_rev_off_twitch_week_minus_3
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 PRECEDING AND 8 PRECEDING) AS channel_rev_off_twitch_week_minus_2
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 PRECEDING AND 1 PRECEDING) AS channel_rev_off_twitch_week_minus_1
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN CURRENT ROW AND 6 FOLLOWING) AS channel_rev_off_twitch_week_plus_1
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 FOLLOWING AND 13 FOLLOWING) AS channel_rev_off_twitch_week_plus_2
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 FOLLOWING AND 20 FOLLOWING) AS channel_rev_off_twitch_week_plus_3
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 FOLLOWING AND 27 FOLLOWING) AS channel_rev_off_twitch_week_plus_4
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 FOLLOWING AND 34 FOLLOWING) AS channel_rev_off_twitch_week_plus_5
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 FOLLOWING AND 41 FOLLOWING) AS channel_rev_off_twitch_week_plus_6
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 FOLLOWING AND 48 FOLLOWING) AS channel_rev_off_twitch_week_plus_7
, SUM(channel_rev_off_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 FOLLOWING AND 55 FOLLOWING) AS channel_rev_off_twitch_week_plus_8

, SUM(channel_rev_on_twitch) AS channel_rev_on_twitch
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 56 PRECEDING AND 50 PRECEDING) AS channel_rev_on_twitch_week_minus_8
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 PRECEDING AND 43 PRECEDING) AS channel_rev_on_twitch_week_minus_7
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 PRECEDING AND 36 PRECEDING) AS channel_rev_on_twitch_week_minus_6
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 PRECEDING AND 29 PRECEDING) AS channel_rev_on_twitch_week_minus_5
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 PRECEDING AND 22 PRECEDING) AS channel_rev_on_twitch_week_minus_4
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 PRECEDING AND 15 PRECEDING) AS channel_rev_on_twitch_week_minus_3
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 PRECEDING AND 8 PRECEDING) AS channel_rev_on_twitch_week_minus_2
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 PRECEDING AND 1 PRECEDING) AS channel_rev_on_twitch_week_minus_1
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN CURRENT ROW AND 6 FOLLOWING) AS channel_rev_on_twitch_week_plus_1
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 FOLLOWING AND 13 FOLLOWING) AS channel_rev_on_twitch_week_plus_2
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 FOLLOWING AND 20 FOLLOWING) AS channel_rev_on_twitch_week_plus_3
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 FOLLOWING AND 27 FOLLOWING) AS channel_rev_on_twitch_week_plus_4
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 FOLLOWING AND 34 FOLLOWING) AS channel_rev_on_twitch_week_plus_5
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 FOLLOWING AND 41 FOLLOWING) AS channel_rev_on_twitch_week_plus_6
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 FOLLOWING AND 48 FOLLOWING) AS channel_rev_on_twitch_week_plus_7
, SUM(channel_rev_on_twitch) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 FOLLOWING AND 55 FOLLOWING) AS channel_rev_on_twitch_week_plus_8

, SUM(channel_rev_total) AS channel_rev_total
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 56 PRECEDING AND 50 PRECEDING) AS channel_rev_total_week_minus_8
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 PRECEDING AND 43 PRECEDING) AS channel_rev_total_week_minus_7
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 PRECEDING AND 36 PRECEDING) AS channel_rev_total_week_minus_6
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 PRECEDING AND 29 PRECEDING) AS channel_rev_total_week_minus_5
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 PRECEDING AND 22 PRECEDING) AS channel_rev_total_week_minus_4
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 PRECEDING AND 15 PRECEDING) AS channel_rev_total_week_minus_3
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 PRECEDING AND 8 PRECEDING) AS channel_rev_total_week_minus_2
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 PRECEDING AND 1 PRECEDING) AS channel_rev_total_week_minus_1
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN CURRENT ROW AND 6 FOLLOWING) AS channel_rev_total_week_plus_1
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 7 FOLLOWING AND 13 FOLLOWING) AS channel_rev_total_week_plus_2
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 14 FOLLOWING AND 20 FOLLOWING) AS channel_rev_total_week_plus_3
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 21 FOLLOWING AND 27 FOLLOWING) AS channel_rev_total_week_plus_4
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 28 FOLLOWING AND 34 FOLLOWING) AS channel_rev_total_week_plus_5
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 35 FOLLOWING AND 41 FOLLOWING) AS channel_rev_total_week_plus_6
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 42 FOLLOWING AND 48 FOLLOWING) AS channel_rev_total_week_plus_7
, SUM(channel_rev_total) OVER (PARTITION BY channel_id ORDER BY day ROWS BETWEEN 49 FOLLOWING AND 55 FOLLOWING) AS channel_rev_total_week_plus_8

FROM full_daily_metrics
GROUP BY day, channel_id, channel, the_group, tier
, mins_watched
, mins_broadcast
, channel_rev_ads
, channel_rev_prime_sub
, channel_rev_paid_sub
, channel_rev_bits
, channel_rev_donation_muxy
, channel_rev_donation_streamlabs
, channel_rev_off_twitch
, channel_rev_on_twitch
, channel_rev_total
