-- by yanghung
-- generate broadcaster weekly_metrics

DROP TABLE IF EXISTS    analysis.panalysis879_broadcaster_weekly_metrics;
CREATE TABLE    analysis.panalysis879_broadcaster_weekly_metrics    AS


SELECT dm.channel_id, dm.channel, dm.the_group, dm.tier, dm.the_week, dm.the_week_range
, SUM(dm.mins_watched) AS mins_watched
, SUM(dm.mins_broadcast) AS mins_broadcast
, SUM(dm.channel_rev_ads) AS channel_rev_ads
, SUM(dm.channel_rev_prime_sub) AS channel_rev_prime_sub
, SUM(dm.channel_rev_paid_sub) AS channel_rev_paid_sub
, SUM(dm.channel_rev_bits) AS channel_rev_bits
, SUM(dm.channel_rev_donation_muxy) AS channel_rev_donation_muxy
, SUM(dm.channel_rev_donation_streamlabs) AS channel_rev_donation_streamlabs
, SUM(dm.channel_rev_off_twitch) AS channel_rev_off_twitch
, SUM(dm.channel_rev_on_twitch) AS channel_rev_on_twitch
, SUM(dm.channel_rev_total) AS channel_rev_total
FROM analysis.panalysis879_broadcaster_daily_metrics AS dm
WHERE day>='2016-01-03' --First Sunday of 2016 for full weeks
GROUP BY channel_id, channel, the_group, tier, the_week, the_week_range
;
