WITH
banned_users AS (
  SELECT DISTINCT target_id AS channel_id
  FROM logs.ban_user
)

SELECT the_group, tier, COUNT(DISTINCT channel_id) AS num_channels, MIN(mins_broadcast) AS min_mb, AVG(mins_broadcast) AS avg_mb, MAX(mins_broadcast) AS max_mb
, MIN(mins_watched) AS min_mw, AVG(mins_watched) AS avg_mw, MAX(mins_watched) AS max_mw
, MIN(channel_rev_on_twitch) AS min_rev_on, AVG(channel_rev_on_twitch) AS avg_rev_on, MAX(channel_rev_on_twitch) AS max_rev_on
, MIN(channel_rev_off_twitch) AS min_rev_off, AVG(channel_rev_off_twitch) AS avg_rev_off, MAX(channel_rev_off_twitch) AS max_rev_off
FROM
(
SELECT channel_id, the_group, tier, SUM(mins_broadcast) AS mins_broadcast, SUM(mins_watched) AS mins_watched
, SUM(channel_rev_on_twitch) AS channel_rev_on_twitch, SUM(channel_rev_off_twitch) AS channel_rev_off_twitch
FROM analysis.panalysis879_broadcaster_weekly_lookup
WHERE day>='2016-01-01' AND tier IS NOT NULL
GROUP BY channel_id, the_group, tier
)
WHERE mins_broadcast>=100 AND mins_watched>=500 AND channel_rev_on_twitch>=0.01 --filter for only 'serious' streamers who got at least monetized by 1 bit
AND channel_id NOT IN (SELECT * FROM banned_users)
GROUP BY the_group, tier
ORDER BY the_group, tier
