-- by yanghung
-- generate list of eligible broadcasters we will use for comparison of difference in difference
-- >=100 mb, >=500 mw, >=0.01 rev_on_twitch (bits+ads+subs)
-- never banned

DROP TABLE IF EXISTS    analysis.panalysis879_eligible_broadcasters;
CREATE TABLE    analysis.panalysis879_eligible_broadcasters    AS


WITH
channel_rollup AS (
  SELECT channel_id, the_group, tier
  , SUM(mins_broadcast) AS mins_broadcast, SUM(mins_watched) AS mins_watched
  , SUM(channel_rev_on_twitch) AS channel_rev_on_twitch, SUM(channel_rev_off_twitch) AS channel_rev_off_twitch
  FROM analysis.panalysis879_broadcaster_weekly_lookup
  WHERE day>='2016-01-01' AND tier IS NOT NULL
  GROUP BY channel_id, the_group, tier
)
, banned_users AS (
  SELECT DISTINCT target_id AS channel_id
  FROM logs.ban_user
)
, eligible_channels AS (
  SELECT channel_id, the_group, tier, mins_broadcast AS lifetime_mb, mins_watched AS lifetime_mw
  , channel_rev_on_twitch AS lifetime_rev_on_twitch, channel_rev_off_twitch AS lifetime_rev_off_twitch
  FROM channel_rollup
  WHERE mins_broadcast>=100 AND mins_watched>=500 AND channel_rev_on_twitch>=0.01 --filter for only 'serious' streamers who got at least monetized by 1 bit
  AND channel_id NOT IN (SELECT * FROM banned_users) --never banned
)

SELECT * FROM eligible_channels
