-- David Hoffman
-- Can you check our most recent broadcast on the /Warcraft channel on Saturday 8/5/17, and pull the number of linked Twitch accounts?
-- I would like to give it as a percentage of viewers if possible as well.


WITH
-- There should only be 1 row of data (i.e. 1 stream) for this query
the_timeframe AS (
SELECT 'jax_live_channel' as the_table, rails_channel_id AS channel_id, LOWER(rails_channel) AS channel_name_lower, usher_id AS stream_id, rails_game_id AS game_id, rails_meta_game AS game
, MIN(time) AS stream_start_time, MAX(time) AS stream_end_time, CAST(EXTRACT(SECONDS FROM (MAX(time) - MIN(time))) AS REAL)/60 AS stream_mins
FROM logs.jax_live_channel
WHERE rails_channel_id = 37516578 --warcraft channel
AND time>='2017-08-05 00:00:00' AND time<'2017-08-06 00:00:00'
GROUP BY 1,2,3,4,5,6
)

, watched_stream AS (
SELECT DISTINCT user_id
FROM logs."minute-watched"
WHERE channel_id = 37516578 --warcraft channel
AND user_id IS NOT NULL
AND time>=(SELECT stream_start_time - INTERVAL '15 minutes' FROM the_timeframe)
AND time<=(SELECT stream_end_time + INTERVAL '15 minutes' FROM the_timeframe)
)

, avg_ccu AS (
SELECT channel_id, SUM(total) as mw, SUM(1) as mb, AVG(total::FLOAT) as avg_ccu
FROM logs.channel_concurrents
WHERE time>=(SELECT stream_start_time - INTERVAL '15 minutes' FROM the_timeframe)
AND time<=(SELECT stream_end_time + INTERVAL '15 minutes' FROM the_timeframe)
AND channel_id = 37516578 --warcraft channel
GROUP BY channel_id
)

, accounts_link AS (
SELECT COUNT(1) AS num_links
FROM analysis.sitedb_battlenet_users
WHERE linked_on>=(SELECT stream_start_time - INTERVAL '15 minutes' FROM the_timeframe)
AND linked_on<=(SELECT stream_end_time + INTERVAL '15 minutes' FROM the_timeframe)
AND user_id IN (SELECT user_id FROM watched_stream)
)

SELECT a.num_links, b.avg_ccu, a.num_links::FLOAT/b.avg_ccu::FLOAT AS ratio
FROM accounts_link a
LEFT JOIN avg_ccu b on 1=1
