-- x% of Partner streamers have authorized a third-party app on Twitch
-- Over xx applications are registered on Twitch
-- and we have xx API calls made each minute.

WITH

the_timeframe AS (
SELECT '2017-01-01 00:00:00' AS start_time, '2017-08-01 00:00:00' AS end_time
)

, api_calls AS (
SELECT DATE_TRUNC('minute', "time") AS the_minute, COUNT(1) AS calls_per_min
FROM logs.api_request
WHERE time>=(SELECT start_time FROM the_timeframe) AND time<(SELECT end_time FROM the_timeframe)
GROUP BY 1
)

SELECT AVG(calls_per_min::FLOAT) AS avg_calls_per_min
FROM api_calls
