DROP TABLE IF EXISTS    analysis.panalysis1026_five_min_play_log;
CREATE TABLE    analysis.panalysis1026_five_min_play_log    AS


WITH
the_timeframe AS (
SELECT '2017-05-24 13:00:00' AS start_time, '2017-08-26 23:59:59' AS end_time
)
, whitelist_channels AS (
SELECT DISTINCT whitelist_broadcaster_id::varchar
FROM analysis.extension_whitelist_broadcaster_latest
)


SELECT start_time AS "time", play_session_id, channel_id::varchar, device_id, user_id AS login_id, platform, content_mode, vod_id, vod_type, play_session_segment, 1 AS one_play
FROM rollups.five_minute_play_segments
WHERE (start_time)>=(SELECT start_time FROM the_timeframe) AND (start_time)<=(SELECT end_time FROM the_timeframe)
AND channel_id IN (SELECT whitelist_broadcaster_id FROM whitelist_channels)
;
