WITH
the_timeframe AS (
--SELECT '2017-05-24 13:00:00' AS start_time, '2017-08-24 23:59:59' AS end_time
SELECT '2017-07-25 00:00:00' AS start_time, '2017-08-26 23:59:59' AS end_time
)

, join_click AS (
SELECT bl.game, bl.game_id, bl.channel_id, bl.channel_name, bl.stream_id, bl.stream_start_time, bl.stream_end_time, bl.stream_mins
, SUM(ecl.one_click) AS num_clicks, COUNT(DISTINCT ecl.device_id) AS num_devices_click
FROM analysis.panalysis1026_broadcast_log AS bl
LEFT JOIN analysis.panalysis1026_extension_click_log AS ecl
ON bl.stream_start_time<=ecl.time AND ecl.time<=bl.stream_end_time AND bl.channel_id = ecl.channel_id
WHERE bl.stream_mins>10 --stream session at least 10 mins (filter out test streams)
AND ecl.extension_id IS NOT NULL
GROUP BY 1,2,3,4,5,6,7,8
)


, join_five_mp AS (
SELECT bl.game, bl.game_id, bl.channel_id, bl.channel_name, bl.stream_id, bl.stream_start_time, bl.stream_end_time, bl.stream_mins
, SUM(fmp.one_play) AS num_five_min_plays, COUNT(DISTINCT fmp.device_id) AS num_devices_five_min_play
FROM analysis.panalysis1026_broadcast_log AS bl
LEFT JOIN analysis.panalysis1026_five_min_play_log AS fmp
ON bl.stream_start_time<=fmp.time AND fmp.time<=bl.stream_end_time AND bl.channel_id = fmp.channel_id
WHERE bl.stream_mins>10 --stream session at least 10 mins (filter out test streams)
GROUP BY 1,2,3,4,5,6,7,8
)


SELECT a.*, b.num_five_min_plays, b.num_devices_five_min_play
FROM
(
SELECT *
FROM join_click
WHERE num_clicks>0 AND num_devices_click>0
) AS a
INNER JOIN
(
SELECT *
FROM join_five_mp
) AS b
ON a.channel_id=b.channel_id AND a.game_id=b.game_id AND a.stream_id = b.stream_id AND a.stream_start_time=b.stream_start_time AND a.stream_end_time=b.stream_end_time
ORDER BY 4,6


--WHERE base.num_channels>=5 AND base.num_streams>=10 AND base.stream_mins>=500 AND base.num_renders>0 AND base.num_devices>0 AND base.extension_id IS NOT NULL

--ORDER BY 1,4,3
