WITH
the_timeframe AS (
--SELECT '2017-05-24 13:00:00' AS start_time, '2017-08-24 23:59:59' AS end_time
SELECT '2017-07-25 00:00:00' AS start_time, '2017-08-26 23:59:59' AS end_time
)
, whitelist_channels AS (
SELECT DISTINCT whitelist_broadcaster_id::varchar
FROM analysis.extension_whitelist_broadcaster_latest
)
, broadcast_log AS (
SELECT rails_channel_id::varchar AS channel_id, LOWER(rails_channel) AS channel_name, usher_id AS stream_id, rails_game_id AS game_id, rails_meta_game AS game
, MIN(time) AS stream_start_time, MAX(time) AS stream_end_time, CAST(EXTRACT(SECONDS FROM (MAX(time) - MIN(time))) AS REAL)/60 AS stream_mins
FROM logs.jax_live_channel
WHERE (time)>=(SELECT start_time FROM the_timeframe) AND (time)<=(SELECT end_time FROM the_timeframe)
AND rails_channel_id IN (SELECT whitelist_broadcaster_id FROM whitelist_channels)
GROUP BY 1,2,3,4,5
)

, extension_click_log AS (
SELECT "time", channel_id::varchar, device_id, extension_id, extension_version, 1 AS one_click
FROM logs.extension_click
WHERE (time)>=(SELECT start_time FROM the_timeframe) AND (time)<=(SELECT end_time FROM the_timeframe)
AND channel_id IN (SELECT whitelist_broadcaster_id FROM whitelist_channels)
)

, five_min_play_log AS (
SELECT start_time AS "time", play_session_id, channel_id::varchar, device_id, user_id AS login_id, platform, content_mode, vod_id, vod_type, play_session_segment, 1 AS one_play
FROM rollups.five_minute_play_segments
WHERE (start_time)>=(SELECT start_time FROM the_timeframe) AND (start_time)<=(SELECT end_time FROM the_timeframe)
AND channel_id IN (SELECT whitelist_broadcaster_id FROM whitelist_channels)
)

SELECT * FROM
(
SELECT bl.game, bl.game_id, ecl.extension_id, bl.channel_name, bl.stream_id
, SUM(bl.stream_mins) AS stream_mins, SUM(one_click) AS num_clicks, COUNT(DISTINCT ecl.device_id) AS num_devices_click, SUM(one_play) AS num_five_min_plays, COUNT(DISTINCT fmp.device_id) AS num_devices_five_min_play
FROM broadcast_log AS bl
LEFT JOIN extension_click_log AS ecl
ON bl.stream_start_time<=ecl.time AND ecl.time<=bl.stream_end_time AND bl.channel_id = ecl.channel_id
LEFT JOIN five_min_play_log AS fmp
ON bl.stream_start_time<=fmp.time AND fmp.time<=bl.stream_end_time AND bl.channel_id = fmp.channel_id
WHERE bl.stream_mins>10 --stream session at least 10 mins (filter out test streams)
GROUP BY 1,2,3,4,5
) AS base
WHERE extension_id IS NOT NULL-- AND num_clicks>0 AND num_devices_click>0
--WHERE base.num_channels>=5 AND base.num_streams>=10 AND base.stream_mins>=500 AND base.num_renders>0 AND base.num_devices>0 AND base.extension_id IS NOT NULL

--ORDER BY 1,4,3
